/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.model;

import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXNormalizationBounds;
import heronarts.lx.transform.LXMatrix;
import heronarts.lx.transform.LXTransform;
import heronarts.lx.transform.LXVector;
import heronarts.lx.utils.LXUtils;

public class LXPoint {
    private static int counter = 0;
    public float x;
    public float y;
    public float z;
    public float r;
    public float rc;
    public float rxy;
    public float rxz;
    public float theta;
    public float azimuth;
    public float elevation;
    public float xn = 0.0f;
    public float yn = 0.0f;
    public float zn = 0.0f;
    public float rn = 0.0f;
    public float rcn = 0.0f;
    public int index;

    public LXPoint() {
        this(0.0f, 0.0f, 0.0f);
    }

    public LXPoint(float x, float y) {
        this(x, y, 0.0f);
    }

    public LXPoint(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.index = counter++;
        this.set();
    }

    public LXPoint(LXPoint that) {
        this.set(that);
    }

    public LXPoint(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public LXPoint(LXVector v) {
        this(v.x, v.y, v.z);
    }

    public LXPoint(LXTransform transform) {
        this(transform.x(), transform.y(), transform.z());
    }

    public LXPoint set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this.set();
    }

    public LXPoint set(LXTransform transform) {
        return this.set(transform.x(), transform.y(), transform.z());
    }

    public LXPoint set(LXMatrix matrix) {
        return this.set(matrix.x(), matrix.y(), matrix.z());
    }

    public LXPoint set(LXMatrix matrix, LXPoint that) {
        float x2 = matrix.m11 * that.x + matrix.m12 * that.y + matrix.m13 * that.z + matrix.m14;
        float y2 = matrix.m21 * that.x + matrix.m22 * that.y + matrix.m23 * that.z + matrix.m24;
        float z2 = matrix.m31 * that.x + matrix.m32 * that.y + matrix.m33 * that.z + matrix.m34;
        return this.set(x2, y2, z2);
    }

    public LXPoint set(LXMatrix matrix, LXVector that) {
        float x2 = matrix.m11 * that.x + matrix.m12 * that.y + matrix.m13 * that.z + matrix.m14;
        float y2 = matrix.m21 * that.x + matrix.m22 * that.y + matrix.m23 * that.z + matrix.m24;
        float z2 = matrix.m31 * that.x + matrix.m32 * that.y + matrix.m33 * that.z + matrix.m34;
        return this.set(x2, y2, z2);
    }

    public LXPoint set(LXPoint that) {
        this.x = that.x;
        this.y = that.y;
        this.z = that.z;
        this.index = that.index;
        this.r = that.r;
        this.rxy = that.rxy;
        this.rxz = that.rxz;
        this.theta = that.theta;
        this.azimuth = that.azimuth;
        this.elevation = that.elevation;
        this.xn = that.xn;
        this.yn = that.yn;
        this.zn = that.zn;
        this.rn = that.rn;
        this.rc = that.rc;
        this.rcn = that.rcn;
        return this;
    }

    public LXPoint setX(float x) {
        this.x = x;
        return this.set();
    }

    public LXPoint setY(float y) {
        this.y = y;
        return this.set();
    }

    public LXPoint setZ(float z) {
        this.z = z;
        return this.set();
    }

    protected LXPoint set() {
        this.r = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.rxy = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        this.rxz = (float)Math.sqrt(this.x * this.x + this.z * this.z);
        this.theta = (float)((Math.PI * 2 + Math.atan2(this.y, this.x)) % (Math.PI * 2));
        this.azimuth = (float)((Math.PI * 2 + Math.atan2(this.x, this.z)) % (Math.PI * 2));
        this.elevation = (float)Math.atan2(this.y, this.rxz);
        return this;
    }

    public LXPoint multiply(LXMatrix matrix) {
        float x2 = matrix.m11 * this.x + matrix.m12 * this.y + matrix.m13 * this.z + matrix.m14;
        float y2 = matrix.m21 * this.x + matrix.m22 * this.y + matrix.m23 * this.z + matrix.m24;
        float z2 = matrix.m31 * this.x + matrix.m32 * this.y + matrix.m33 * this.z + matrix.m34;
        return this.set(x2, y2, z2);
    }

    void normalize(LXNormalizationBounds bounds, LXModel model) {
        float px = bounds.px(this);
        float py = bounds.py(this);
        float pz = bounds.pz(this);
        this.xn = bounds.xRange == 0.0f ? 0.5f : (px - bounds.xMin) / bounds.xRange;
        this.yn = bounds.yRange == 0.0f ? 0.5f : (py - bounds.yMin) / bounds.yRange;
        this.zn = bounds.zRange == 0.0f ? 0.5f : (pz - bounds.zMin) / bounds.zRange;
        this.rn = model.rMax == 0.0f ? 0.0f : (float)Math.sqrt(px * px + py * py + pz * pz) / model.rMax;
        this.rc = LXUtils.distf(px, py, pz, bounds.cx, bounds.cy, bounds.cz);
    }

    @Deprecated
    public float xn(LXNormalizationBounds bounds) {
        return bounds.xRange == 0.0f ? 0.5f : (bounds.px(this) - bounds.xMin) / bounds.xRange;
    }

    @Deprecated
    public float yn(LXNormalizationBounds bounds) {
        return bounds.yRange == 0.0f ? 0.5f : (bounds.py(this) - bounds.yMin) / bounds.yRange;
    }

    @Deprecated
    public float zn(LXNormalizationBounds bounds) {
        return bounds.zRange == 0.0f ? 0.5f : (bounds.pz(this) - bounds.zMin) / bounds.zRange;
    }
}

