/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.model;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.structure.view.LXViewDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LXView
extends LXModel {
    private static final String GROUP_SEPARATOR = "\\s*;\\s*";
    private static final String SELECTOR_SEPARATOR = "\\s*,\\s*";
    private static final char GROUP_OPERATOR = '*';
    private final LXModel model;
    final Normalization normalization;
    final Map<Integer, LXPoint> clonedPoints;

    public static LXView create(LXModel model, String viewSelector, Normalization normalization, Orientation orientation) {
        return LXView.create(model, viewSelector, normalization, orientation, null);
    }

    public static LXView create(LXModel model, String viewSelector, Normalization normalization, Orientation orientation, LXViewDefinition viewDefinition) {
        ParseState state = new ParseState(model);
        boolean invalidOrientation = false;
        String[] stringArray = viewSelector.trim().split(GROUP_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String groupSelector = stringArray[n2];
            LXView.parseGroup(state, groupSelector);
            ++n2;
        }
        HashMap<Integer, LXPoint> clonedPoints = new HashMap<Integer, LXPoint>();
        LXView[] views = new LXView[state.groups.size()];
        ArrayList<LXPoint> allPoints = new ArrayList<LXPoint>();
        int g = 0;
        int numFixtures = 0;
        for (List<LXModel> group : state.groups) {
            ArrayList<LXPoint> groupPoints = new ArrayList<LXPoint>();
            LXModel[] groupChildren = new LXModel[group.size()];
            numFixtures += group.size();
            int c = 0;
            for (LXModel sub : group) {
                LXPoint[] lXPointArray = sub.points;
                int n3 = sub.points.length;
                int n4 = 0;
                while (n4 < n3) {
                    LXPoint p = lXPointArray[n4];
                    if (!clonedPoints.containsKey(p.index)) {
                        LXPoint copy = new LXPoint(p);
                        clonedPoints.put(p.index, copy);
                        groupPoints.add(copy);
                        allPoints.add(copy);
                    }
                    ++n4;
                }
                groupChildren[c++] = LXView.cloneModel(clonedPoints, sub);
            }
            if (normalization == Normalization.RELATIVE && orientation == Orientation.GROUP && groupChildren.length != 1) {
                invalidOrientation = true;
            }
            views[g++] = new LXView(model, normalization, orientation, clonedPoints, groupPoints, groupChildren, viewSelector);
        }
        if (viewDefinition != null) {
            viewDefinition.numGroups.setValue(views.length);
            viewDefinition.numFixtures.setValue(numFixtures);
            viewDefinition.invalidOrientation.setValue(invalidOrientation);
        }
        if (views.length == 0) {
            return new Empty(model, clonedPoints, allPoints, views, viewSelector);
        }
        if (views.length == 1) {
            return views[0];
        }
        return new Container(model, clonedPoints, allPoints, views, viewSelector);
    }

    private static void parseGroup(ParseState state, String groupSelector) {
        if ((groupSelector = groupSelector.trim()).isEmpty()) {
            return;
        }
        int subgroup = groupSelector.lastIndexOf(42);
        if (subgroup >= 0) {
            String rootSelector = groupSelector.substring(0, subgroup).replace('*', ' ').trim();
            String subSelector = groupSelector.substring(subgroup + 1).trim();
            ArrayList<LXModel> groupRoots = new ArrayList<LXModel>();
            boolean terminal = subSelector.isEmpty();
            LXView.parseGroupSelector(state, state.model, groupRoots, rootSelector, terminal);
            for (LXModel groupRoot : groupRoots) {
                ArrayList<LXModel> group = new ArrayList<LXModel>();
                if (terminal) {
                    group.add(groupRoot);
                    state.groups.add(group);
                    continue;
                }
                LXView.parseGroupSelector(state, groupRoot, group, subSelector, true);
                if (group.isEmpty()) continue;
                state.groups.add(group);
            }
        } else {
            ArrayList<LXModel> group = new ArrayList<LXModel>();
            LXView.parseGroupSelector(state, state.model, group, groupSelector, true);
            if (!group.isEmpty()) {
                state.groups.add(group);
            }
        }
    }

    private static void parseGroupSelector(ParseState state, LXModel root, List<LXModel> group, String groupSelector, boolean terminal) {
        String[] stringArray = groupSelector.split(SELECTOR_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String selector = stringArray[n2];
            LXView.parseSubselector(state, root, group, selector, terminal);
            ++n2;
        }
    }

    private static void parseSubselector(ParseState state, LXModel root, List<LXModel> group, String selector, boolean terminal) {
        if ((selector = selector.trim()).isEmpty()) {
            return;
        }
        ArrayList<LXModel> candidates = new ArrayList<LXModel>();
        candidates.add(root);
        ArrayList<LXModel> searchSpace = new ArrayList<LXModel>();
        ArrayList<LXModel> intersect = new ArrayList<LXModel>();
        boolean directChildMode = false;
        boolean andMode = false;
        String[] stringArray = selector.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String tag = part.trim();
            if (">".equals(tag)) {
                directChildMode = true;
            } else if ("&".equals(tag)) {
                andMode = true;
            } else {
                if (andMode) {
                    intersect.clear();
                    intersect.addAll(candidates);
                } else {
                    searchSpace.clear();
                    searchSpace.addAll(candidates);
                }
                candidates.clear();
                int startIndex = 0;
                int endIndex = -1;
                int increment = 1;
                int rangeStart = tag.indexOf(91);
                int rangeEnd = tag.indexOf(93);
                if (rangeStart >= 0) {
                    if (rangeEnd < 0 || rangeEnd <= rangeStart) {
                        LX.error("Poorly formatted view selection range: " + tag);
                    } else {
                        String range = tag.substring(rangeStart + 1, rangeEnd).trim();
                        tag = tag.substring(0, rangeStart);
                        if ("even".equals(range)) {
                            increment = 2;
                        } else if ("odd".equals(range)) {
                            startIndex = 1;
                            increment = 2;
                        } else {
                            int dash;
                            boolean hasIncrement;
                            int colon = range.indexOf(":");
                            boolean bl = hasIncrement = colon >= 0;
                            if (hasIncrement) {
                                try {
                                    increment = Integer.parseInt(range.substring(colon + 1).trim());
                                    range = range.substring(0, colon).trim();
                                }
                                catch (NumberFormatException nfx) {
                                    LX.error("Bad number in view selection range: " + tag);
                                }
                            }
                            if ((dash = range.indexOf(45)) >= 0) {
                                try {
                                    startIndex = Integer.parseInt(range.substring(0, dash).trim());
                                    endIndex = Integer.parseInt(range.substring(dash + 1).trim());
                                }
                                catch (NumberFormatException nfx) {
                                    LX.error("Bad number in view selection range: " + tag);
                                }
                            } else {
                                try {
                                    if (hasIncrement) {
                                        if (!range.isEmpty()) {
                                            startIndex = Integer.parseInt(range);
                                        }
                                    } else {
                                        startIndex = endIndex = Integer.parseInt(range);
                                    }
                                }
                                catch (NumberFormatException nfx) {
                                    LX.error("Bad number in view selection range: " + tag);
                                }
                            }
                        }
                    }
                }
                for (LXModel search : searchSpace) {
                    List<LXModel> subs = andMode ? search.sub(tag) : (directChildMode ? search.children(tag) : search.sub(tag));
                    if (increment < 1) {
                        increment = 1;
                    }
                    if (startIndex < 0) {
                        startIndex = 0;
                    }
                    if (endIndex < 0 || endIndex >= subs.size()) {
                        endIndex = subs.size() - 1;
                    }
                    int i = startIndex;
                    while (i <= endIndex) {
                        LXModel sub = subs.get(i);
                        if (!state.uniqueSubmodels.contains(sub)) {
                            candidates.add(subs.get(i));
                        }
                        i += increment;
                    }
                }
                if (andMode) {
                    Iterator iter = candidates.iterator();
                    while (iter.hasNext()) {
                        LXModel candidate = (LXModel)iter.next();
                        if (intersect.contains(candidate)) continue;
                        iter.remove();
                    }
                }
                directChildMode = false;
                andMode = false;
            }
            ++n2;
        }
        if (terminal) {
            LXView.addGroupCandidates(state, group, candidates);
        } else {
            group.addAll(candidates);
        }
    }

    private static void addGroupCandidates(ParseState state, List<LXModel> group, List<LXModel> candidates) {
        for (LXModel candidate : candidates) {
            if (state.uniqueSubmodels.contains(candidate)) continue;
            boolean isDescendant = false;
            Iterator<LXModel> iter = state.uniqueSubmodels.iterator();
            while (!isDescendant && iter.hasNext()) {
                LXModel submodel = iter.next();
                if (submodel.contains(candidate)) {
                    isDescendant = true;
                    continue;
                }
                if (!candidate.contains(submodel)) continue;
                iter.remove();
                for (List<LXModel> existingGroup : state.groups) {
                    existingGroup.remove(submodel);
                }
            }
            if (isDescendant) continue;
            state.uniqueSubmodels.add(candidate);
            group.add(candidate);
        }
    }

    private static LXModel cloneModel(Map<Integer, LXPoint> clonedPoints, LXModel model) {
        ArrayList<LXPoint> points = new ArrayList<LXPoint>(model.points.length);
        LXPoint[] lXPointArray = model.points;
        int n = model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            points.add(clonedPoints.get(p.index));
            ++n2;
        }
        LXModel[] children = new LXModel[model.children.length];
        int i = 0;
        while (i < children.length) {
            children[i] = LXView.cloneModel(clonedPoints, model.children[i]);
            ++i;
        }
        LXModel clone = new LXModel(points, children, model.getNormalizationBounds(), model.metaData, model.tags, model.meshes);
        clone.transform.set(model.transform);
        return clone;
    }

    final String allTags(List<String> tags) {
        Object tag = "";
        for (String t : tags) {
            tag = (String)tag + t + " ";
        }
        return tag;
    }

    private LXView(LXModel model, Normalization normalization, Orientation orientation, Map<Integer, LXPoint> clonedPoints, List<LXPoint> points, LXModel[] children, String viewSelector) {
        this(model, normalization, orientation, true, clonedPoints, points, children, viewSelector);
    }

    private LXView(LXModel model, Normalization normalization, Orientation orientation, boolean setChildBounds, Map<Integer, LXPoint> clonedPoints, List<LXPoint> points, LXModel[] children, String viewSelector) {
        super(points, children, normalization == Normalization.ABSOLUTE ? model.getNormalizationBounds() : null, setChildBounds, "view");
        this.model = model;
        this.normalization = normalization;
        this.clonedPoints = Collections.unmodifiableMap(clonedPoints);
        model.derivedViews.add(this);
        if (normalization == Normalization.RELATIVE) {
            if (orientation == Orientation.GROUP) {
                if (children.length == 1) {
                    this.setNormalizationOrientation(children[0]);
                } else {
                    LX.error("LXView.Orientation.SELF requires groups with a single fixture: \"" + viewSelector + "\" matches " + children.length + " fixtures");
                }
            }
            this.normalizePoints();
        }
    }

    @Override
    public LXModel getMainRoot() {
        return this.model.getMainRoot();
    }

    @Override
    public void dispose() {
        this.model.derivedViews.remove(this);
        super.dispose();
    }

    public static class Container
    extends LXView {
        private Container(LXModel model, Map<Integer, LXPoint> clonedPoints, List<LXPoint> points, LXView[] views, String viewSelector) {
            super(model, Normalization.ABSOLUTE, Orientation.GLOBAL, false, clonedPoints, points, views, viewSelector);
        }
    }

    public static class Empty
    extends LXView {
        private Empty(LXModel model, Map<Integer, LXPoint> clonedPoints, List<LXPoint> points, LXView[] views, String viewSelector) {
            super(model, Normalization.ABSOLUTE, Orientation.GLOBAL, clonedPoints, points, views, viewSelector);
        }
    }

    public static enum Normalization {
        RELATIVE("Constrain to view bounds"),
        ABSOLUTE("Preserve absolute bounds");

        public final String description;

        private Normalization(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Orientation {
        GLOBAL("In absolute coordinate space"),
        GROUP("In view group coordinate space");

        public final String description;

        private Orientation(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class ParseState {
        private final LXModel model;
        private final List<List<LXModel>> groups = new ArrayList<List<LXModel>>();
        private final List<LXModel> uniqueSubmodels = new ArrayList<LXModel>();

        private ParseState(LXModel model) {
            this.model = model;
        }
    }
}

