/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulation;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.modulation.LXModulationEngine;
import heronarts.lx.modulation.LXParameterModulation;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.List;

public class LXCompoundModulation
extends LXParameterModulation {
    public final LXNormalizedParameter source;
    public final Target target;
    public final EnumParameter<LXParameter.Polarity> polarity = new EnumParameter<LXParameter.Polarity>("Polarity", LXParameter.Polarity.UNIPOLAR).setDescription("Specifies whether this modulation is unipolar (one-directional) or bipolar (bi-directional)");
    public final CompoundParameter range = new CompoundParameter("Range", 0.0, -1.0, 1.0).setDescription("Specifies the depth of this modulation, may be positive or negative").setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR);

    public LXCompoundModulation(LX lx, LXModulationEngine scope, JsonObject obj) throws LXParameterModulation.ModulationException {
        this(scope, (LXNormalizedParameter)LXCompoundModulation.getParameter(lx, scope, obj.getAsJsonObject("source")), (Target)LXCompoundModulation.getParameter(lx, scope, obj.getAsJsonObject("target")));
    }

    public LXCompoundModulation(LXModulationEngine scope, LXNormalizedParameter source, Target target) throws LXParameterModulation.ModulationException {
        super(scope, source, target);
        this.source = source;
        this.target = target;
        this.polarity.setValue((Object)source.getPolarity());
        this.addParameter("polarity", this.polarity);
        this.addParameter("range", this.range);
        this.addLegacyParameter("Polarity", this.polarity);
        this.addLegacyParameter("Range", this.range);
        target.addModulation(this);
        this.setParent(scope);
    }

    public LXCompoundModulation setPolarity(LXParameter.Polarity polarity) {
        this.polarity.setValue((Object)polarity);
        return this;
    }

    public LXParameter.Polarity getPolarity() {
        return this.polarity.getEnum();
    }

    public double getModulationAmount() {
        if (!this.enabled.isOn()) {
            return 0.0;
        }
        if (this.getPolarity() == LXParameter.Polarity.UNIPOLAR) {
            return this.source.getNormalized() * this.range.getValue();
        }
        return 2.0 * (this.source.getNormalized() - 0.5) * this.range.getValue();
    }

    @Override
    public String getPath() {
        return "modulation/" + (this.index + 1);
    }

    @Override
    public void dispose() {
        this.target.removeModulation(this);
        super.dispose();
    }

    public static interface Listener {
        public void modulationAdded(Target var1, LXCompoundModulation var2);

        public void modulationRemoved(Target var1, LXCompoundModulation var2);
    }

    public static interface Target
    extends LXNormalizedParameter {
        public List<LXCompoundModulation> getModulations();

        public List<LXCompoundModulation> getUIThreadModulations();

        public Target addModulation(LXCompoundModulation var1);

        public Target removeModulation(LXCompoundModulation var1);

        public Target addModulationListener(Listener var1);

        public Target removeModulationListener(Listener var1);
    }
}

