/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXEngine;
import heronarts.lx.LXModulatorComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.LXShortMessage;
import heronarts.lx.midi.MidiPanic;
import heronarts.lx.modulation.LXCompoundModulation;
import heronarts.lx.modulation.LXParameterModulation;
import heronarts.lx.modulation.LXTriggerModulation;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.parameter.LXParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LXModulationEngine
extends LXModulatorComponent
implements LXOscComponent {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<LXCompoundModulation> mutableModulations = new ArrayList<LXCompoundModulation>();
    public final List<LXCompoundModulation> modulations = Collections.unmodifiableList(this.mutableModulations);
    private final List<LXTriggerModulation> mutableTriggers = new ArrayList<LXTriggerModulation>();
    public final List<LXTriggerModulation> triggers = Collections.unmodifiableList(this.mutableTriggers);
    private boolean flagLoadModulations = true;
    private static final String KEY_MODULATORS = "modulators";
    private static final String KEY_MODULATIONS = "modulations";
    private static final String KEY_TRIGGERS = "triggers";

    public LXModulationEngine(LX lx) {
        super(lx, "Modulation");
        this.addArray("modulation", this.modulations);
        this.addArray("trigger", this.triggers);
    }

    public LXModulationEngine setFlagLoadModulations(boolean flagLoadModulations) {
        this.flagLoadModulations = flagLoadModulations;
        return this;
    }

    public boolean isValidTarget(LXParameter target) {
        LXComponent parent = this.getParent();
        if (parent instanceof LXEngine) {
            return true;
        }
        LXComponent targetComponent = target.getParent();
        while (targetComponent != null) {
            if (targetComponent == parent) {
                return true;
            }
            targetComponent = targetComponent.getParent();
        }
        return false;
    }

    @Override
    public boolean handleOscMessage(OscMessage message, String[] parts, int index) {
        String path = parts[index];
        for (LXModulator modulator : this.modulators) {
            if (!path.equals(modulator.getOscPath())) continue;
            return modulator.handleOscMessage(message, parts, index + 1);
        }
        return super.handleOscMessage(message, parts, index);
    }

    public LXModulationEngine addListener(Listener listener) {
        Objects.requireNonNull(listener, "May not add null LXModulationEngine.Listener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXModulationEngine.Listener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LXModulationEngine removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent LXModulationEngine.Listener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXModulationEngine addModulation(LXCompoundModulation modulation) {
        if (this.mutableModulations.contains(modulation)) {
            throw new IllegalStateException("Cannot add duplicate LXCompoundModulation: " + String.valueOf(modulation));
        }
        this.mutableModulations.add(modulation);
        this._reindex(this.modulations);
        for (Listener listener : this.listeners) {
            listener.modulationAdded(this, modulation);
        }
        return this;
    }

    public LXModulationEngine removeModulation(LXCompoundModulation modulation) {
        if (!this.mutableModulations.contains(modulation)) {
            throw new IllegalStateException("Cannot remove non-registered LXCompoundModulation: " + String.valueOf(modulation));
        }
        this.mutableModulations.remove(modulation);
        for (Listener listener : this.listeners) {
            listener.modulationRemoved(this, modulation);
        }
        this._reindex(this.modulations);
        LX.dispose(modulation);
        return this;
    }

    public LXModulationEngine addTrigger(LXTriggerModulation trigger) {
        if (this.mutableTriggers.contains(trigger)) {
            throw new IllegalStateException("Cannot add duplicate LXTriggerModulation: " + String.valueOf(trigger));
        }
        this.mutableTriggers.add(trigger);
        this._reindex(this.triggers);
        for (Listener listener : this.listeners) {
            listener.triggerAdded(this, trigger);
        }
        return this;
    }

    public LXModulationEngine removeTrigger(LXTriggerModulation trigger) {
        if (!this.mutableTriggers.contains(trigger)) {
            throw new IllegalStateException("Cannot remove non-registered LXTriggerModulation: " + String.valueOf(trigger));
        }
        this.mutableTriggers.remove(trigger);
        this._reindex(this.triggers);
        for (Listener listener : this.listeners) {
            listener.triggerRemoved(this, trigger);
        }
        LX.dispose(trigger);
        return this;
    }

    private void _reindex(List<? extends LXParameterModulation> modulations) {
        int i = 0;
        for (LXParameterModulation lXParameterModulation : modulations) {
            lXParameterModulation.setIndex(i++);
        }
    }

    public <T extends LXParameterModulation> List<T> findModulations(LXComponent component, List<T> modulations) {
        ArrayList<LXParameterModulation> found = null;
        for (LXParameterModulation modulation : modulations) {
            if (!component.contains(modulation.source) && !component.contains(modulation.target)) continue;
            if (found == null) {
                found = new ArrayList<LXParameterModulation>();
            }
            found.add(modulation);
        }
        return found;
    }

    private <T extends LXParameterModulation> List<T> findParameterModulations(LXParameter parameter, List<T> modulations) {
        ArrayList<LXParameterModulation> found = null;
        for (LXParameterModulation modulation : modulations) {
            if (modulation.source != parameter && modulation.target != parameter) continue;
            if (found == null) {
                found = new ArrayList<LXParameterModulation>();
            }
            found.add(modulation);
        }
        return found;
    }

    public LXModulationEngine removeParameterModulations(LXParameter parameter) {
        List<LXTriggerModulation> triggers;
        List<LXCompoundModulation> compounds = this.findParameterModulations(parameter, this.modulations);
        if (compounds != null) {
            for (LXCompoundModulation compound : compounds) {
                this.removeModulation(compound);
            }
        }
        if ((triggers = this.findParameterModulations(parameter, this.triggers)) != null) {
            for (LXTriggerModulation trigger : triggers) {
                this.removeTrigger(trigger);
            }
        }
        return this;
    }

    public LXModulationEngine removeModulations(LXComponent component) {
        List<LXTriggerModulation> triggers;
        List<LXCompoundModulation> compounds = this.findModulations(component, this.modulations);
        if (compounds != null) {
            for (LXCompoundModulation compound : compounds) {
                this.removeModulation(compound);
            }
        }
        if ((triggers = this.findModulations(component, this.triggers)) != null) {
            for (LXTriggerModulation trigger : triggers) {
                this.removeTrigger(trigger);
            }
        }
        return this;
    }

    @Override
    public <T extends LXModulator> T addModulator(T modulator, int index, JsonObject modulatorObj) {
        super.addModulator(modulator, index, modulatorObj);
        for (Listener listener : this.listeners) {
            listener.modulatorAdded(this, modulator);
        }
        return modulator;
    }

    @Override
    public <T extends LXModulator> T removeModulator(T modulator) {
        this.removeModulations(modulator);
        for (Listener listener : this.listeners) {
            listener.modulatorRemoved(this, modulator);
        }
        super.removeModulator(modulator);
        return modulator;
    }

    @Override
    public <T extends LXModulator> T moveModulator(T modulator, int index) {
        super.moveModulator(modulator, index);
        for (Listener listener : this.listeners) {
            listener.modulatorMoved(this, modulator);
        }
        return modulator;
    }

    public int getModulatorCount(Class<? extends LXModulator> cls) {
        int count = 0;
        for (LXModulator modulator : this.modulators) {
            if (!cls.isAssignableFrom(modulator.getClass())) continue;
            ++count;
        }
        return count;
    }

    public void midiDispatch(LXShortMessage message) {
        for (LXModulator modulator : this.modulators) {
            if (!(modulator instanceof LXMidiListener)) continue;
            LXMidiListener listener = (LXMidiListener)((Object)modulator);
            if (message instanceof MidiPanic) {
                modulator.midiFilter.midiPanic();
                message.dispatch(listener);
                continue;
            }
            if (!modulator.running.isOn() || !modulator.midiSource.matches(message.getSource()) || !modulator.midiFilter.filter(message)) continue;
            message.dispatch(listener);
        }
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
        this.listeners.forEach(listener -> LX.warning("Stranded LXModulationEngine.Listener: " + String.valueOf(listener)));
        this.listeners.clear();
    }

    @Override
    public String getLabel() {
        return "Modulation";
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_MODULATORS, (JsonElement)LXSerializable.Utils.toArray(lx, this.modulators));
        obj.add(KEY_MODULATIONS, (JsonElement)LXSerializable.Utils.toArray(lx, this.modulations));
        obj.add(KEY_TRIGGERS, (JsonElement)LXSerializable.Utils.toArray(lx, this.triggers));
    }

    public void clear() {
        int i = this.modulators.size() - 1;
        while (i >= 0) {
            this.removeModulator((LXModulator)this.modulators.get(i));
            --i;
        }
        i = this.modulations.size() - 1;
        while (i >= 0) {
            this.removeModulation(this.modulations.get(i));
            --i;
        }
        i = this.triggers.size() - 1;
        while (i >= 0) {
            this.removeTrigger(this.triggers.get(i));
            --i;
        }
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        this.clear();
        super.load(lx, obj);
        if (obj.has(KEY_MODULATORS)) {
            JsonArray modulatorArr = obj.getAsJsonArray(KEY_MODULATORS);
            for (JsonElement modulatorElement : modulatorArr) {
                LXModulator modulator;
                JsonObject modulatorObj = modulatorElement.getAsJsonObject();
                String modulatorClass = modulatorObj.get("class").getAsString();
                try {
                    modulator = this.lx.instantiateModulator(modulatorClass);
                }
                catch (LX.InstantiationException x) {
                    LX.error("Using placeholder class for missing modulator: " + modulatorClass);
                    modulator = new LXModulator.Placeholder(this.lx, x, modulatorObj);
                    this.lx.pushError(x, modulatorClass + " could not be loaded. " + x.getMessage());
                }
                this.addModulator(modulator);
                modulator.load(lx, modulatorObj);
            }
        }
        if (this.flagLoadModulations) {
            this.loadModulations(lx, obj);
        }
    }

    public void loadModulations(LX lx, JsonObject obj) {
        if (obj.has(KEY_MODULATIONS)) {
            JsonArray modulationArr = obj.getAsJsonArray(KEY_MODULATIONS);
            for (JsonElement modulationElement : modulationArr) {
                JsonObject modulationObj = modulationElement.getAsJsonObject();
                try {
                    LXCompoundModulation modulation = new LXCompoundModulation(this.lx, this, modulationObj);
                    this.addModulation(modulation);
                    modulation.load(lx, modulationObj);
                }
                catch (Exception x) {
                    LX.error(x, "Could not load modulation " + modulationObj.toString());
                }
            }
        }
        if (obj.has(KEY_TRIGGERS)) {
            JsonArray triggerArr = obj.getAsJsonArray(KEY_TRIGGERS);
            for (JsonElement triggerElement : triggerArr) {
                JsonObject triggerObj = triggerElement.getAsJsonObject();
                try {
                    LXTriggerModulation trigger = new LXTriggerModulation(this.lx, this, triggerObj);
                    this.addTrigger(trigger);
                    trigger.load(lx, triggerObj);
                }
                catch (Exception x) {
                    LX.error(x, "Could not load trigger mapping " + triggerObj.toString());
                }
            }
        }
    }

    public static interface Listener {
        public void modulatorAdded(LXModulationEngine var1, LXModulator var2);

        public void modulatorRemoved(LXModulationEngine var1, LXModulator var2);

        public void modulatorMoved(LXModulationEngine var1, LXModulator var2);

        public void modulationAdded(LXModulationEngine var1, LXCompoundModulation var2);

        public void modulationRemoved(LXModulationEngine var1, LXCompoundModulation var2);

        public void triggerAdded(LXModulationEngine var1, LXTriggerModulation var2);

        public void triggerRemoved(LXModulationEngine var1, LXTriggerModulation var2);

        public static interface Default
        extends Listener {
            @Override
            default public void modulatorAdded(LXModulationEngine engine, LXModulator modulator) {
            }

            @Override
            default public void modulatorRemoved(LXModulationEngine engine, LXModulator modulator) {
            }

            @Override
            default public void modulatorMoved(LXModulationEngine engine, LXModulator modulator) {
            }

            @Override
            default public void modulationAdded(LXModulationEngine engine, LXCompoundModulation modulation) {
            }

            @Override
            default public void modulationRemoved(LXModulationEngine engine, LXCompoundModulation modulation) {
            }

            @Override
            default public void triggerAdded(LXModulationEngine engine, LXTriggerModulation modulation) {
            }

            @Override
            default public void triggerRemoved(LXModulationEngine engine, LXTriggerModulation modulation) {
            }
        }
    }
}

