/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXPath;
import heronarts.lx.color.DiscreteColorParameter;
import heronarts.lx.modulation.LXModulationEngine;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class LXParameterModulation
extends LXComponent {
    protected int index = -1;
    public final LXModulationEngine scope;
    public final LXParameter source;
    public final LXParameter target;
    public final DiscreteColorParameter color;
    public final DiscreteColorParameter clr;
    public final BooleanParameter enabled = new BooleanParameter("Enabled", true).setDescription("Whether this modulation is enabled");
    private static Map<LXParameter, List<LXParameter>> modulationGraph = new HashMap<LXParameter, List<LXParameter>>();
    protected static final String KEY_SOURCE = "source";
    protected static final String KEY_TARGET = "target";

    private static void checkForCycles(LXParameter source, LXParameter target, LXParameter candidate) throws CircularDependencyException {
        List<LXParameter> candidates;
        if (source == candidate) {
            throw new CircularDependencyException("Mapping from " + source.getLabel() + " to " + target.getLabel() + " is not allowed because it would create a circular dependency.");
        }
        LXComponent candidateParent = candidate.getParent();
        if (candidateParent instanceof LXParameterModulation) {
            LXParameterModulation.checkForCycles(source, target, ((LXParameterModulation)candidateParent).source);
        }
        if ((candidates = modulationGraph.get(candidate)) != null) {
            for (LXParameter candidate2 : candidates) {
                LXParameterModulation.checkForCycles(source, target, candidate2);
            }
        }
    }

    private static void registerModulation(LXParameter source, LXParameter target) throws CircularDependencyException {
        LXParameterModulation.checkForCycles(source, target, target);
        if (!modulationGraph.containsKey(source)) {
            modulationGraph.put(source, new ArrayList());
        }
        modulationGraph.get(source).add(target);
    }

    private static void unregisterModulation(LXParameter source, LXParameter target) {
        modulationGraph.get(source).remove(target);
    }

    private void checkScope(LXModulationEngine scope, LXParameter parameter) throws InvalidScopeException {
        LXComponent domain = scope.getParent();
        LXComponent component = parameter.getParent();
        while (component != null) {
            if (component == domain) {
                return;
            }
            component = component.getParent();
        }
        throw new InvalidScopeException(scope, parameter);
    }

    protected LXParameterModulation(LXModulationEngine scope, LXParameter source, LXParameter target) throws ModulationException {
        if (source == null) {
            throw new IllegalArgumentException("LXParameterModulation source may not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("LXParameterModulation target may not be null");
        }
        if (source.getParent() == null && !(source instanceof LXComponent)) {
            throw new IllegalStateException("May not create parameter modulation from source registered to no component: " + source.toString());
        }
        if (target.getParent() == null) {
            throw new IllegalStateException("May not create parameter modulation to target registered to no component: " + target.toString());
        }
        LXParameterModulation.registerModulation(source, target);
        this.checkScope(scope, source);
        this.checkScope(scope, target);
        this.scope = scope;
        this.source = source;
        this.target = target;
        this.clr = this.color = source instanceof LXComponent ? ((LXComponent)((Object)source)).modulationColor : source.getParent().modulationColor;
        this.addParameter("enabled", this.enabled);
    }

    public LXParameterModulation setIndex(int index) {
        this.index = index;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public LXParameter getTarget() {
        return this.target;
    }

    @Override
    public String getLabel() {
        return this.source.getLabel() + " > " + this.target.getLabel();
    }

    protected static LXParameter getParameter(LX lx, LXModulationEngine scope, JsonObject obj) {
        if (obj.has("path")) {
            LXParameter parameter = LXPath.getParameter(scope.getParent(), obj.get("path").getAsString());
            if (parameter != null) {
                return parameter;
            }
            LX.error("Failed to locate parameter at " + obj.get("path").getAsString() + " in scope " + String.valueOf(scope.getParent()));
        }
        if (obj.has("id")) {
            return (LXParameter)((Object)lx.getProjectComponent(obj.get("id").getAsInt()));
        }
        LXComponent component = lx.getProjectComponent(obj.get("componentId").getAsInt());
        String path = obj.get("parameterPath").getAsString();
        return component.getParameter(path);
    }

    @Override
    public void dispose() {
        LXParameterModulation.unregisterModulation(this.source, this.target);
        super.dispose();
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        JsonObject sourceObj = new JsonObject();
        if (this.source instanceof LXComponent) {
            LXComponent sourceComponent = (LXComponent)((Object)this.source);
            sourceObj.addProperty("id", (Number)sourceComponent.getId());
        } else {
            sourceObj.addProperty("componentId", (Number)this.source.getParent().getId());
            sourceObj.addProperty("parameterPath", this.source.getPath());
        }
        sourceObj.addProperty("path", this.source.getCanonicalPath(this.scope.getParent()));
        obj.add(KEY_SOURCE, (JsonElement)sourceObj);
        JsonObject targetObj = new JsonObject();
        targetObj.addProperty("componentId", (Number)this.target.getParent().getId());
        targetObj.addProperty("parameterPath", this.target.getPath());
        targetObj.addProperty("path", this.target.getCanonicalPath(this.scope.getParent()));
        obj.add(KEY_TARGET, (JsonElement)targetObj);
        super.save(lx, obj);
    }

    public static class CircularDependencyException
    extends ModulationException {
        private static final long serialVersionUID = 1L;

        private CircularDependencyException(String message) {
            super(message);
        }
    }

    public static class InvalidScopeException
    extends ModulationException {
        private static final long serialVersionUID = 1L;

        private InvalidScopeException(LXModulationEngine scope, LXParameter parameter) {
            super("Parameter " + String.valueOf(parameter) + " is not in valid scope for modulation engine " + String.valueOf(scope.getParent()));
        }
    }

    public static class ModulationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected ModulationException(String message) {
            super(message);
        }
    }
}

