/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXModulator;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public class Accelerator
extends LXModulator {
    private double initValue;
    private double velocity;
    private LXParameter initVelocity;
    private LXParameter acceleration;

    public Accelerator(double initValue, double initVelocity, double acceleration) {
        this(initValue, initVelocity, (LXParameter)new FixedParameter(acceleration));
    }

    public Accelerator(double initValue, double initVelocity, LXParameter acceleration) {
        this("ACCEL", initValue, initVelocity, acceleration);
    }

    public Accelerator(double initValue, LXParameter initVelocity, LXParameter acceleration) {
        this("ACCEL", initValue, initVelocity, acceleration);
    }

    public Accelerator(String label, double initValue, double initVelocity, double acceleration) {
        this(label, initValue, new FixedParameter(initVelocity), (LXParameter)new FixedParameter(acceleration));
    }

    public Accelerator(String label, double initValue, double initVelocity, LXParameter acceleration) {
        this(label, initValue, new FixedParameter(initVelocity), acceleration);
    }

    public Accelerator(String label, double initValue, LXParameter initVelocity, LXParameter acceleration) {
        super(label);
        this.initValue = initValue;
        this.setValue(this.initValue);
        this.setSpeed(initVelocity, acceleration);
    }

    @Override
    protected void onReset() {
        this.setVelocity(this.initVelocity.getValue());
        this.setValue(this.initValue);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public float getVelocityf() {
        return (float)this.getVelocity();
    }

    public double getAcceleration() {
        return this.acceleration.getValue();
    }

    public float getAccelerationf() {
        return (float)this.getAcceleration();
    }

    public Accelerator setSpeed(double initVelocity, double acceleration) {
        return this.setSpeed(new FixedParameter(initVelocity), new FixedParameter(acceleration));
    }

    public Accelerator setSpeed(LXParameter initVelocity, LXParameter acceleration) {
        this.initVelocity = initVelocity;
        this.velocity = this.initVelocity.getValue();
        this.acceleration = acceleration;
        return this;
    }

    public Accelerator setVelocity(double velocity) {
        this.velocity = velocity;
        return this;
    }

    public Accelerator setInitVelocity(double initVelocity) {
        return this.setInitVelocity(new FixedParameter(initVelocity));
    }

    public Accelerator setInitVelocity(LXParameter initVelocity) {
        this.initVelocity = initVelocity;
        return this;
    }

    public Accelerator setAcceleration(double acceleration) {
        return this.setAcceleration(new FixedParameter(acceleration));
    }

    public Accelerator setAcceleration(LXParameter acceleration) {
        this.acceleration = acceleration;
        return this;
    }

    @Override
    protected double computeValue(double deltaMs) {
        double a = this.getAcceleration();
        double dt = deltaMs / 1000.0;
        double s = this.getValue() + this.velocity * dt + 0.5 * a * dt * dt;
        this.velocity += a * dt;
        return s;
    }
}

