/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXModulator;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public class Accumulator
extends LXModulator {
    private final LXParameter velocity;
    private float sign = 1.0f;
    private int collisions = 0;

    public Accumulator() {
        this("ACCUM");
    }

    public Accumulator(double velocity) {
        this("ACCUM", velocity);
    }

    public Accumulator(LXParameter velocity) {
        this("ACCUM", velocity);
    }

    public Accumulator(String label) {
        this(label, 1.0);
    }

    public Accumulator(String label, double velocity) {
        this(label, new FixedParameter(velocity));
    }

    public Accumulator(String label, LXParameter velocity) {
        super(label);
        this.velocity = velocity;
    }

    @Override
    protected double computeValue(double deltaMs) {
        float currentValue = this.getValuef();
        float amount = (float)(deltaMs * this.velocity.getValue());
        if (amount == 0.0f) {
            return currentValue;
        }
        float newValue = currentValue + this.sign * amount;
        if ((currentValue == newValue || Float.isInfinite(newValue)) && ++this.collisions > 3) {
            this.collisions = 0;
            this.sign = -this.sign;
            int i = 0;
            do {
                newValue = currentValue + this.sign * amount;
                amount *= 10.0f;
            } while (newValue == currentValue && i++ < 10);
        }
        return newValue;
    }
}

