/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXPeriodicModulator;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public class Click
extends LXPeriodicModulator {
    private boolean fired = false;

    public Click(double periodMs) {
        this(new FixedParameter(periodMs));
    }

    public Click(LXParameter periodMs) {
        this("CLICK", periodMs);
    }

    public Click(String label, double periodMs) {
        this(label, new FixedParameter(periodMs));
    }

    public Click(String label, LXParameter periodMs) {
        super(label, periodMs);
    }

    @Override
    public void loop(double deltaMs) {
        if (!this.isRunning()) {
            this.setValue(0.0, false);
        }
        super.loop(deltaMs);
        this.fired = false;
    }

    public LXModulator fire() {
        this.setValue(1.0, false);
        this.setBasis(0.0);
        this.start();
        this.fired = true;
        return this;
    }

    public boolean click() {
        return this.getValue() == 1.0;
    }

    @Override
    protected double computeValue(double deltaMs, double basis) {
        return this.fired || this.loop() || this.finished() ? 1 : 0;
    }

    @Override
    protected double computeBasis(double basis, double value) {
        return !(value < 1.0) ? 1 : 0;
    }
}

