/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;

@LXModulator.Global(value="Comparator")
@LXModulator.Device(value="Comparator")
@LXCategory(value="Trigger")
public class ComparatorModulator
extends LXModulator
implements LXTriggerSource,
LXOscComponent {
    public final CompoundParameter in1 = new CompoundParameter("In-1", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("First input value");
    public final CompoundParameter in2 = new CompoundParameter("In-2", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Second input value");
    public final EnumParameter<Comparison> comparison = new EnumParameter<Comparison>("Comparison", Comparison.LESS).setDescription("Comparison to make between inputs");
    public final BooleanParameter out = new BooleanParameter("Out", false).setDescription("Output value");

    public ComparatorModulator() {
        this("Comparator");
    }

    public ComparatorModulator(String label) {
        super(label);
        this.addParameter("in1", this.in1);
        this.addParameter("in2", this.in2);
        this.addParameter("comparison", this.comparison);
        this.addParameter("out", this.out);
        this.setMappingSource(false);
    }

    @Override
    protected double computeValue(double deltaMs) {
        double in1 = this.in1.getValue();
        double in2 = this.in2.getValue();
        boolean result = this.comparison.getEnum().compare(in1, in2);
        this.out.setValue(result);
        return result ? 1 : 0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.out;
    }

    public static enum Comparison {
        GREATER(">"),
        GREATER_EQUAL(">="),
        LESS("<"),
        LESS_EQUAL("<="),
        EQUAL("=="),
        NOT_EQUAL("!=");

        public final String label;

        private Comparison(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public boolean compare(double left, double right) {
            switch (this) {
                case EQUAL: {
                    return left == right;
                }
                case GREATER: {
                    return left > right;
                }
                case GREATER_EQUAL: {
                    return left >= right;
                }
                case LESS: {
                    return left < right;
                }
                case LESS_EQUAL: {
                    return left <= right;
                }
                case NOT_EQUAL: {
                    return left != right;
                }
            }
            return false;
        }
    }
}

