/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;

@LXModulator.Global(value="Cycle")
@LXModulator.Device(value="Cycle")
@LXCategory(value="Core")
public class CycleModulator
extends LXModulator
implements LXNormalizedParameter,
LXOscComponent {
    private double basis = 0.0;
    public final CompoundParameter speedUnipolar = new CompoundParameter("Speed", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Speed of motion (unipolar)");
    public final CompoundParameter speedBipolar = new CompoundParameter("Speed", 1.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Speed of motion (bipolar)");
    public final CompoundParameter speedRangeHz = new CompoundParameter("Range", 1.0, 0.0, 10.0).setUnits(LXParameter.Units.HERTZ).setDescription("Maximum range of the speed control in hz");
    public final EnumParameter<LXParameter.Polarity> speedPolarity = new EnumParameter<LXParameter.Polarity>("Speed Polarity", LXParameter.Polarity.UNIPOLAR).setDescription("Speed polarity");

    public CycleModulator() {
        this("Cycle");
    }

    public CycleModulator(String label) {
        super(label);
        this.addParameter("speedUnipolar", this.speedUnipolar);
        this.addParameter("speedBipolar", this.speedBipolar);
        this.addParameter("speedRangeHz", this.speedRangeHz);
        this.addParameter("speedPolarity", this.speedPolarity);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.speedPolarity) {
            if (this.speedPolarity.getEnum() == LXParameter.Polarity.UNIPOLAR) {
                this.speedUnipolar.setValue(Math.abs(this.speedBipolar.getValue()));
            } else {
                this.speedBipolar.setValue(this.speedUnipolar.getValue());
            }
        }
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        this.basis = value;
        return this;
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    @Override
    protected double computeValue(double deltaMs) {
        double speed = this.speedPolarity.getEnum() == LXParameter.Polarity.BIPOLAR ? this.speedBipolar.getValue() : this.speedUnipolar.getValue();
        this.basis += deltaMs / 1000.0 * this.speedRangeHz.getValue() * speed;
        this.basis = this.basis < 0.0 ? 1.0 + this.basis % 1.0 : (this.basis %= 1.0);
        return this.basis;
    }
}

