/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXModulator;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public class DampedParameter
extends LXModulator {
    private final LXParameter parameter;
    private final LXParameter velocity;
    private final LXParameter acceleration;
    private final LXParameter deceleration;
    private double currentVelocity = 0.0;
    private boolean hasModulus = false;
    private double modulus = 0.0;

    public DampedParameter(String label, double velocity) {
        this((LXParameter)new BoundedParameter(label, 0.0, Double.MIN_VALUE, Double.MAX_VALUE), velocity, 0.0);
    }

    public DampedParameter(LXParameter parameter, double velocity) {
        this(parameter, velocity, 0.0);
    }

    public DampedParameter(LXParameter parameter, double velocity, double acceleration) {
        this("DAMPED-" + parameter.getLabel(), parameter, velocity, acceleration, acceleration);
    }

    public DampedParameter(LXParameter parameter, double velocity, double acceleration, double deceleration) {
        this("DAMPED-" + parameter.getLabel(), parameter, velocity, acceleration, deceleration);
    }

    public DampedParameter(LXParameter parameter, LXParameter velocity) {
        this("DAMPED-" + parameter.getLabel(), parameter, velocity, 0.0);
    }

    public DampedParameter(LXParameter parameter, LXParameter velocity, LXParameter acceleration) {
        this("DAMPED-" + parameter.getLabel(), parameter, velocity, acceleration);
    }

    public DampedParameter(LXParameter parameter, LXParameter velocity, LXParameter acceleration, LXParameter deceleration) {
        this("DAMPED-" + parameter.getLabel(), parameter, velocity, acceleration, deceleration);
    }

    public DampedParameter(String label, LXParameter parameter, LXParameter velocity) {
        this(label, parameter, velocity, 0.0);
    }

    public DampedParameter(String label, LXParameter parameter, double velocity, double acceleration) {
        this(label, parameter, velocity, acceleration, acceleration);
    }

    public DampedParameter(String label, LXParameter parameter, double velocity, double acceleration, double deceleration) {
        this(label, parameter, (LXParameter)new FixedParameter(velocity), new FixedParameter(acceleration), new FixedParameter(deceleration));
    }

    public DampedParameter(String label, LXParameter parameter, LXParameter velocity, double acceleration) {
        this(label, parameter, velocity, acceleration, acceleration);
    }

    public DampedParameter(String label, LXParameter parameter, LXParameter velocity, double acceleration, double deceleration) {
        this(label, parameter, velocity, new FixedParameter(acceleration), new FixedParameter(deceleration));
    }

    public DampedParameter(String label, LXParameter parameter, LXParameter velocity, LXParameter acceleration) {
        this(label, parameter, velocity, acceleration, acceleration);
    }

    public DampedParameter(String label, LXParameter parameter, LXParameter velocity, LXParameter acceleration, LXParameter deceleration) {
        super(label);
        this.parameter = parameter;
        this.velocity = velocity;
        this.acceleration = acceleration;
        this.deceleration = deceleration;
        this.updateValue(parameter.getValue());
    }

    public DampedParameter setModulus(double modulus) {
        this.modulus = modulus;
        this.hasModulus = modulus > 0.0;
        return this;
    }

    public DampedParameter setModulus(boolean hasModulus) {
        this.hasModulus = hasModulus && this.modulus > 0.0;
        return this;
    }

    @Override
    protected double computeValue(double deltaMs) {
        double target;
        double value = this.getValue();
        if (value == (target = this.parameter.getValue())) {
            this.currentVelocity = 0.0;
            return value;
        }
        if (this.hasModulus) {
            if (target < value) {
                double wrapTarget = target + this.modulus;
                if (Math.abs(value - wrapTarget) < Math.abs(value - target)) {
                    target = wrapTarget;
                }
            } else {
                double wrapValue = value + this.modulus;
                if (Math.abs(wrapValue - target) < Math.abs(value - target)) {
                    value = wrapValue;
                }
            }
        }
        double av = Math.abs(this.acceleration.getValue());
        double dv = Math.abs(this.deceleration.getValue());
        double vv = Math.abs(this.velocity.getValue());
        double deltaS = deltaMs / 1000.0;
        if (av > 0.0 || dv > 0.0) {
            double position = value;
            if (target < value) {
                av = -av;
                dv = -dv;
            }
            double decelTime = Math.abs(this.currentVelocity / dv);
            double decelPosition = position + this.currentVelocity * decelTime - 0.5 * dv * decelTime * decelTime;
            if (target > value) {
                if (this.currentVelocity > 0.0 && decelPosition > target) {
                    position = Math.min(target, value + this.currentVelocity * deltaS + 0.5 * -dv * deltaS * deltaS);
                    this.currentVelocity = Math.max(0.0, this.currentVelocity - dv * deltaS);
                } else {
                    position = Math.min(target, value + this.currentVelocity * deltaS + 0.5 * av * deltaS * deltaS);
                    this.currentVelocity = Math.min(vv, this.currentVelocity + av * deltaS);
                }
            } else if (this.currentVelocity < 0.0 && decelPosition < target) {
                position = Math.max(target, value + this.currentVelocity * deltaS + 0.5 * -dv * deltaS * deltaS);
                this.currentVelocity = Math.min(0.0, this.currentVelocity - dv * deltaS);
            } else {
                position = Math.max(target, value + this.currentVelocity * deltaS + 0.5 * av * deltaS * deltaS);
                this.currentVelocity = Math.max(-vv, this.currentVelocity + av * deltaS);
            }
            if (this.hasModulus) {
                position %= this.modulus;
            }
            return position;
        }
        double range = vv * deltaS;
        double after = target > value ? Math.min(value + range, target) : Math.max(value - range, target);
        if (this.hasModulus) {
            after %= this.modulus;
        }
        return after;
    }

    public LXParameter getParameter() {
        return this.parameter;
    }
}

