/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.Tempo;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.TimeParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.util.Calendar;

@LXModulator.Global(value="Damper")
@LXModulator.Device(value="Damper")
@LXCategory(value="Core")
public class Damper
extends LXModulator
implements LXNormalizedParameter,
LXTriggerSource,
LXOscComponent,
LXMidiListener {
    public final BooleanParameter toggle = new BooleanParameter("Toggle", false).setDescription("Toggle whether the damper is engaged");
    public final TriggerParameter triggerEngage = new TriggerParameter("Engage").setDescription("Trigger the damper to engage");
    public final TriggerParameter triggerRelease = new TriggerParameter("Release").setDescription("Trigger the damper to release");
    public final CompoundParameter periodMs = new CompoundParameter("Interval", 1000.0, 10.0, 300000.0).setExponent(3.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Base interval for random target value updates");
    public final BooleanParameter tempoSync = new BooleanParameter("Sync", false).setDescription("Whether this modulator syncs to a tempo");
    public final EnumParameter<Tempo.Division> tempoDivision = new EnumParameter<Tempo.Division>("Division", Tempo.Division.QUARTER).setDescription("Tempo division when in sync mode");
    public final BooleanParameter sinShaping = new BooleanParameter("Ease", false).setDescription("Whether to apply sinusoidal easing");
    public final BooleanParameter timing = new BooleanParameter("Timing", false).setDescription("Whether to apply automatic timing");
    public final TimeParameter engageTime = new TimeParameter("Engage Time").setDescription("What time of day the timer engages");
    public final TimeParameter releaseTime = new TimeParameter("Release Time").setDescription("What time of day the timer releases");
    public final BooleanParameter engageTimerOut = new BooleanParameter("Engage Timer").setDescription("Indicates when the engage timer fires").setMode(BooleanParameter.Mode.MOMENTARY);
    public final BooleanParameter releaseTimerOut = new BooleanParameter("Release Timer").setDescription("Indicates when the release timer fires").setMode(BooleanParameter.Mode.MOMENTARY);
    private double basis = 0.0;
    private final Calendar calendar = Calendar.getInstance();
    private boolean noteOn = false;

    public Damper() {
        this("Damper");
    }

    private Damper(String label) {
        super(label);
        this.midiFilter.enabled.setValue(false);
        this.addParameter("toggle", this.toggle);
        this.addParameter("triggerEngage", this.triggerEngage);
        this.addParameter("triggerRelease", this.triggerRelease);
        this.addParameter("periodMs", this.periodMs);
        this.addParameter("tempoSync", this.tempoSync);
        this.addParameter("tempoDivision", this.tempoDivision);
        this.addParameter("sinShaping", this.sinShaping);
        this.addParameter("timing", this.timing);
        this.addParameter("engageTime", this.engageTime);
        this.addParameter("releaseTime", this.releaseTime);
        this.addParameter("engageTimerOut", this.engageTimerOut);
        this.addParameter("releaseTimerOut", this.releaseTimerOut);
        this.setDescription("Damped value that moves from 0 to 1 with multiple triggers");
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.toggle) {
            this.start();
        } else if (p == this.engageTimerOut) {
            if (this.engageTimerOut.isOn()) {
                this.triggerEngage.setValue(true);
            }
        } else if (p == this.releaseTimerOut) {
            if (this.releaseTimerOut.isOn()) {
                this.triggerRelease.setValue(true);
            }
        } else if (p == this.triggerEngage) {
            if (this.triggerEngage.isOn()) {
                this.toggle.setValue(true);
                this.start();
            }
        } else if (p == this.triggerRelease && this.triggerRelease.isOn()) {
            this.toggle.setValue(false);
            this.start();
        }
    }

    @Override
    protected double computeValue(double deltaMs) {
        if (this.timing.isOn()) {
            this.calendar.setTimeInMillis(System.currentTimeMillis());
            int thisSeconds = TimeParameter.getSecondsOfDay(this.calendar);
            int engageSeconds = this.engageTime.getSecondsOfDay();
            int releaseSeconds = this.releaseTime.getSecondsOfDay();
            this.engageTimerOut.setValue(engageSeconds == thisSeconds);
            this.releaseTimerOut.setValue(releaseSeconds == thisSeconds);
        }
        double periodMs = this.tempoSync.isOn() ? this.lx.engine.tempo.period.getValue() * this.tempoDivision.getEnum().multiplier : this.periodMs.getValue();
        double sign = this.toggle.isOn() ? 1 : -1;
        this.basis = LXUtils.clamp(this.basis + sign * deltaMs / periodMs, 0.0, 1.0);
        if (this.sinShaping.isOn()) {
            return 0.5 + 0.5 * Math.sin(-1.5707963267948966 + Math.PI * this.basis);
        }
        return this.basis;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        if (this.sinShaping.isOn()) {
            double radians = Math.asin(2.0 * (value - 0.5));
            this.basis = (radians + 1.5707963267948966) / Math.PI;
        } else {
            this.basis = value;
        }
        return this;
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.toggle;
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.noteOn = true;
        this.toggle.setValue(true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.noteOn = false;
        this.toggle.setValue(false);
    }

    @Override
    public void midiPanicReceived() {
        if (this.noteOn) {
            this.noteOn = false;
            this.toggle.setValue(false);
        }
    }
}

