/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.modulator.LXRangeModulator;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;

public abstract class FunctionalModulator
extends LXRangeModulator {
    public FunctionalModulator(double startValue, double endValue, double periodMs) {
        this((LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(LXParameter startValue, double endValue, double periodMs) {
        this(startValue, (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(double startValue, LXParameter endValue, double periodMs) {
        this((LXParameter)new FixedParameter(startValue), endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(double startValue, double endValue, LXParameter periodMs) {
        this((LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public FunctionalModulator(LXParameter startValue, LXParameter endValue, double periodMs) {
        this(startValue, endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(LXParameter startValue, double endValue, LXParameter periodMs) {
        this(startValue, (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public FunctionalModulator(double startValue, LXParameter endValue, LXParameter periodMs) {
        this((LXParameter)new FixedParameter(startValue), endValue, periodMs);
    }

    public FunctionalModulator(LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        this("SIN", startValue, endValue, periodMs);
    }

    public FunctionalModulator(String label, double startValue, double endValue, double periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(String label, LXParameter startValue, double endValue, double periodMs) {
        this(label, startValue, (LXParameter)new FixedParameter(endValue), (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(String label, double startValue, LXParameter endValue, double periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(String label, double startValue, double endValue, LXParameter periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public FunctionalModulator(String label, LXParameter startValue, LXParameter endValue, double periodMs) {
        this(label, startValue, endValue, (LXParameter)new FixedParameter(periodMs));
    }

    public FunctionalModulator(String label, LXParameter startValue, double endValue, LXParameter periodMs) {
        this(label, startValue, (LXParameter)new FixedParameter(endValue), periodMs);
    }

    public FunctionalModulator(String label, double startValue, LXParameter endValue, LXParameter periodMs) {
        this(label, (LXParameter)new FixedParameter(startValue), endValue, periodMs);
    }

    public FunctionalModulator(String label, LXParameter startValue, LXParameter endValue, LXParameter periodMs) {
        super(label, startValue, endValue, periodMs);
    }

    @Override
    protected double computeNormalizedValue(double deltaMs, double basis) {
        double computed = this.compute(basis);
        if (computed < 0.0 || computed > 1.0) {
            throw new IllegalStateException(this.getClass().getName() + ".compute() must return a value between 0-1, returned " + computed + " for argument " + basis);
        }
        return computed;
    }

    @Override
    protected double computeNormalizedBasis(double basis, double normalizedValue) {
        double inverted = this.invert(basis, normalizedValue);
        if (inverted < 0.0 || inverted > 1.0) {
            throw new IllegalStateException(this.getClass().getName() + ".invert() must return a value between 0-1, returned " + inverted + " for argument " + basis);
        }
        return inverted;
    }

    public abstract double compute(double var1);

    public double invert(double basis, double value) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement invert(), may not directly change range or value.");
    }
}

