/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.modulator.LXMacroModulator;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.StringParameter;

@LXModulator.Global(value="Switches")
@LXModulator.Device(value="Switches")
@LXCategory(value="Macro")
public class MacroSwitches
extends LXMacroModulator
implements LXTriggerSource,
LXMidiListener {
    public final BooleanParameter macro1 = MacroSwitches.macro(1);
    public final BooleanParameter macro2 = MacroSwitches.macro(2);
    public final BooleanParameter macro3 = MacroSwitches.macro(3);
    public final BooleanParameter macro4 = MacroSwitches.macro(4);
    public final BooleanParameter macro5 = MacroSwitches.macro(5);
    public final BooleanParameter macro6 = MacroSwitches.macro(6);
    public final BooleanParameter macro7 = MacroSwitches.macro(7);
    public final BooleanParameter macro8 = MacroSwitches.macro(8);
    public final StringParameter label1 = MacroSwitches.label(1);
    public final StringParameter label2 = MacroSwitches.label(2);
    public final StringParameter label3 = MacroSwitches.label(3);
    public final StringParameter label4 = MacroSwitches.label(4);
    public final StringParameter label5 = MacroSwitches.label(5);
    public final StringParameter label6 = MacroSwitches.label(6);
    public final StringParameter label7 = MacroSwitches.label(7);
    public final StringParameter label8 = MacroSwitches.label(8);
    public final BooleanParameter[] switches = new BooleanParameter[]{this.macro1, this.macro2, this.macro3, this.macro4, this.macro5, this.macro6, this.macro7, this.macro8};
    public final StringParameter[] labels = new StringParameter[]{this.label1, this.label2, this.label3, this.label4, this.label5, this.label6, this.label7, this.label8};

    private static BooleanParameter macro(int num) {
        return new BooleanParameter("B" + num).setDescription("Macro control switch " + num);
    }

    private static StringParameter label(int num) {
        return new StringParameter("Label-" + num, "-").setDescription("Label for switch " + num);
    }

    public MacroSwitches() {
        this("Switches");
    }

    public MacroSwitches(String label) {
        super(label);
        this.midiFilter.enabled.setValue(false);
        this.addParameter("macro1", this.macro1);
        this.addParameter("macro2", this.macro2);
        this.addParameter("macro3", this.macro3);
        this.addParameter("macro4", this.macro4);
        this.addParameter("macro5", this.macro5);
        this.addParameter("macro6", this.macro6);
        this.addParameter("macro7", this.macro7);
        this.addParameter("macro8", this.macro8);
        this.addParameter("label1", this.label1);
        this.addParameter("label2", this.label2);
        this.addParameter("label3", this.label3);
        this.addParameter("label4", this.label4);
        this.addParameter("label5", this.label5);
        this.addParameter("label6", this.label6);
        this.addParameter("label7", this.label7);
        this.addParameter("label8", this.label8);
        this.setMappingSource(false);
    }

    @Override
    protected double computeValue(double deltaMs) {
        return 0.0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return null;
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        int idx = note.getPitch() - this.midiFilter.minNote.getValuei();
        if (idx < this.switches.length) {
            this.switches[idx].toggle();
        }
    }
}

