/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.modulator.LXMacroModulator;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.StringParameter;

@LXModulator.Global(value="Triggers")
@LXModulator.Device(value="Triggers")
@LXCategory(value="Macro")
public class MacroTriggers
extends LXMacroModulator
implements LXTriggerSource,
LXMidiListener {
    public final BooleanParameter macro1 = MacroTriggers.macro(1);
    public final BooleanParameter macro2 = MacroTriggers.macro(2);
    public final BooleanParameter macro3 = MacroTriggers.macro(3);
    public final BooleanParameter macro4 = MacroTriggers.macro(4);
    public final BooleanParameter macro5 = MacroTriggers.macro(5);
    public final BooleanParameter macro6 = MacroTriggers.macro(6);
    public final BooleanParameter macro7 = MacroTriggers.macro(7);
    public final BooleanParameter macro8 = MacroTriggers.macro(8);
    public final StringParameter label1 = MacroTriggers.label(1);
    public final StringParameter label2 = MacroTriggers.label(2);
    public final StringParameter label3 = MacroTriggers.label(3);
    public final StringParameter label4 = MacroTriggers.label(4);
    public final StringParameter label5 = MacroTriggers.label(5);
    public final StringParameter label6 = MacroTriggers.label(6);
    public final StringParameter label7 = MacroTriggers.label(7);
    public final StringParameter label8 = MacroTriggers.label(8);
    public final BooleanParameter[] triggers = new BooleanParameter[]{this.macro1, this.macro2, this.macro3, this.macro4, this.macro5, this.macro6, this.macro7, this.macro8};
    public final StringParameter[] labels = new StringParameter[]{this.label1, this.label2, this.label3, this.label4, this.label5, this.label6, this.label7, this.label8};
    private boolean[] midiOn = new boolean[this.triggers.length];

    private static BooleanParameter macro(int num) {
        return new BooleanParameter("T" + num).setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Macro control trigger " + num);
    }

    private static StringParameter label(int num) {
        return new StringParameter("Label-" + num, "-").setDescription("Label for trigger " + num);
    }

    public MacroTriggers() {
        this("Triggers");
    }

    public MacroTriggers(String label) {
        super(label);
        this.midiFilter.enabled.setValue(false);
        this.addParameter("macro1", this.macro1);
        this.addParameter("macro2", this.macro2);
        this.addParameter("macro3", this.macro3);
        this.addParameter("macro4", this.macro4);
        this.addParameter("macro5", this.macro5);
        this.addParameter("macro6", this.macro6);
        this.addParameter("macro7", this.macro7);
        this.addParameter("macro8", this.macro8);
        this.addParameter("label1", this.label1);
        this.addParameter("label2", this.label2);
        this.addParameter("label3", this.label3);
        this.addParameter("label4", this.label4);
        this.addParameter("label5", this.label5);
        this.addParameter("label6", this.label6);
        this.addParameter("label7", this.label7);
        this.addParameter("label8", this.label8);
        this.setMappingSource(false);
    }

    @Override
    protected double computeValue(double deltaMs) {
        return 0.0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return null;
    }

    private void onMidiTrigger(MidiNote note, boolean value) {
        int trig = note.getPitch() - this.midiFilter.minNote.getValuei();
        if (trig < this.triggers.length) {
            this.midiOn[trig] = true;
            this.triggers[trig].setValue(value);
        }
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.onMidiTrigger(note, true);
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        this.onMidiTrigger(note, false);
    }

    @Override
    public void midiPanicReceived() {
        int i = 0;
        while (i < this.midiOn.length) {
            if (this.midiOn[i]) {
                this.midiOn[i] = false;
                this.triggers[i].setValue(false);
            }
            ++i;
        }
    }
}

