/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.NormalizedParameter;

@LXModulator.Global(value="MIDI Note")
@LXModulator.Device(value="MIDI Note")
@LXCategory(value="Trigger")
public class MidiNoteTrigger
extends LXModulator
implements LXTriggerSource,
LXOscComponent,
LXMidiListener {
    public final BooleanParameter legato = new BooleanParameter("Legato").setDescription("Whether to sustain held legato notes");
    public final BooleanParameter triggerOut = new BooleanParameter("Trigger Out").setMode(BooleanParameter.Mode.MOMENTARY).setDescription("Indicates whenever the MIDI trig fires");
    public final NormalizedParameter pitchOut = new NormalizedParameter("Pitch", 0.0).setDescription("Normalized pitch of the note within valid range");
    public final NormalizedParameter velocityOut = new NormalizedParameter("Velocity", 0.0).setDescription("Normalized velocity of the note within valid range");
    public final BooleanParameter showPitch = new BooleanParameter("Preview", false).setDescription("Whether the note pitch meters are visible in the UI");
    private int noteCount = 0;

    public MidiNoteTrigger() {
        this("MIDI Note");
    }

    public MidiNoteTrigger(String label) {
        super(label);
        this.setMappingSource(false);
        this.addParameter("legato", this.legato);
        this.addParameter("triggerOut", this.triggerOut);
        this.addParameter("pitchOut", this.pitchOut);
        this.addParameter("velocityOut", this.velocityOut);
        this.addParameter("showPitch", this.showPitch);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.legato) {
            this.noteCount = 0;
            this.triggerOut.setValue(false);
        }
    }

    @Override
    protected double computeValue(double deltaMs) {
        return this.pitchOut.getValue();
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        int velocityRange;
        int noteRange;
        ++this.noteCount;
        this.triggerOut.setValue(true);
        if (!this.legato.isOn()) {
            this.triggerOut.setValue(false);
        }
        if ((noteRange = this.midiFilter.noteRange.getValuei()) > 0) {
            if (noteRange == 1) {
                this.pitchOut.setValue(0.5);
            } else {
                int minNote = this.midiFilter.minNote.getValuei();
                this.pitchOut.setValue((double)(note.getPitch() - minNote) / (double)noteRange);
            }
        }
        if ((velocityRange = this.midiFilter.velocityRange.getValuei()) > 0) {
            if (velocityRange == 1) {
                this.velocityOut.setValue(0.5);
            } else {
                int minVelocity = this.midiFilter.minVelocity.getValuei();
                this.velocityOut.setValue((double)(note.getVelocity() - minVelocity) / (double)velocityRange);
            }
        }
    }

    @Override
    public void noteOffReceived(MidiNote note) {
        if (this.noteCount > 0) {
            --this.noteCount;
        }
        if (!this.legato.isOn() || this.noteCount == 0) {
            this.triggerOut.setValue(false);
        }
    }

    @Override
    public void midiPanicReceived() {
        if (this.noteCount > 0) {
            this.noteCount = 0;
            this.triggerOut.setValue(false);
        }
    }
}

