/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.texture.NoisePattern;
import heronarts.lx.utils.LXUtils;
import heronarts.lx.utils.Noise;

@LXModulator.Global(value="Noise")
@LXModulator.Device(value="Noise")
@LXCategory(value="Core")
public class NoiseModulator
extends LXModulator
implements LXNormalizedParameter,
LXOscComponent {
    public final CompoundParameter speed = new CompoundParameter("Speed", 0.25, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Speed of noise animation");
    public final BoundedParameter speedRange = new BoundedParameter("Range", 1.0, 0.0, 5.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Range of speed knob");
    public final CompoundParameter level = new CompoundParameter("Level", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Midpoint brightness level for the noise generation");
    public final CompoundParameter contrast = new CompoundParameter("Contrast", 1.0, 0.0, 5.0).setExponent(2.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Dynamic contrast of noise generation");
    public final CompoundParameter minLevel = new CompoundParameter("Min", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Minimum output level");
    public final CompoundParameter maxLevel = new CompoundParameter("Max", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Maximum output level");
    public final EnumParameter<NoisePattern.Algorithm> algorithm = new EnumParameter<NoisePattern.Algorithm>("Algorithm", NoisePattern.Algorithm.PERLIN);
    public final DiscreteParameter seed = new DiscreteParameter("Seed", 0, 256).setDescription("Seed value supplied to the noise function");
    public final DiscreteParameter octaves = new DiscreteParameter("Octaves", 3, 1, 9).setDescription("Number of octaves of perlin noise to sum");
    public final BoundedParameter lacunarity = new BoundedParameter("Lacunarity", 2.0, 0.0, 4.0).setDescription("Spacing between successive octaves (use exactly 2.0 for wrapping output)");
    public final BoundedParameter gain = new BoundedParameter("Gain", 0.5, 0.0, 1.0).setDescription("Relative weighting applied to each successive octave");
    public final BoundedParameter ridgeOffset = new BoundedParameter("Ridge", 0.9, 0.0, 2.0).setDescription("Used to invert the feedback ridges");
    public final BooleanParameter showPreview = new BooleanParameter("Preview", false).setDescription("Whether the wave preview is visible in the modulator UI");
    private double basis = 0.0;

    public NoiseModulator() {
        this("Noise");
    }

    private NoiseModulator(String label) {
        super(label);
        this.addParameter("speed", this.speed);
        this.addParameter("speedRange", this.speedRange);
        this.addParameter("level", this.level);
        this.addParameter("contrast", this.contrast);
        this.addParameter("minLevel", this.minLevel);
        this.addParameter("maxLevel", this.maxLevel);
        this.addParameter("algorithm", this.algorithm);
        this.addParameter("seed", this.seed);
        this.addParameter("octaves", this.octaves);
        this.addParameter("lacunarity", this.lacunarity);
        this.addParameter("gain", this.gain);
        this.addParameter("ridgeOffset", this.ridgeOffset);
        this.addParameter("showPreview", this.showPreview);
        this.setDescription("Noise generator that produces normalized output");
    }

    private double getNoise(float basis) {
        int octaves = this.octaves.getValuei();
        float lacunarity = this.lacunarity.getValuef();
        float gain = this.gain.getValuef();
        float ridgeOffset = this.ridgeOffset.getValuef();
        switch (this.algorithm.getEnum()) {
            case RIDGE: {
                return Noise.stb_perlin_ridge_noise3(basis, 0.0f, 0.0f, lacunarity, gain, ridgeOffset, octaves);
            }
            case FBM: {
                return Noise.stb_perlin_fbm_noise3(basis, 0.0f, 0.0f, lacunarity, gain, octaves);
            }
            case TURBULENCE: {
                return Noise.stb_perlin_turbulence_noise3(basis, 0.0f, 0.0f, lacunarity, gain, octaves);
            }
            case STATIC: {
                return -1.0 + 2.0 * Math.random();
            }
        }
        return Noise.stb_perlin_noise3_seed(basis, 0.0f, 0.0f, 0, 0, 0, this.seed.getValuei());
    }

    private double _computeValue(float basis) {
        return LXUtils.lerp(this.minLevel.getValue(), this.maxLevel.getValue(), LXUtils.clamp(this.level.getValue() + this.contrast.getValue() * this.getNoise(basis), 0.0, 1.0));
    }

    @Override
    protected double computeValue(double deltaMs) {
        this.basis = (256.0 + (this.basis + deltaMs * 0.001 * this.speedRange.getValue() * this.speed.getValue()) % 256.0) % 256.0;
        return this._computeValue((float)this.basis);
    }

    public double lookahead(double deltaMs) {
        double basis = (256.0 + (this.basis + deltaMs * 0.001 * this.speedRange.getValue() * this.speed.getValue()) % 256.0) % 256.0;
        return this._computeValue((float)basis);
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("NoiseModulator does not support setNormalized()");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }
}

