/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXModulator.Global(value="Operator")
@LXModulator.Device(value="Operator")
@LXCategory(value="Core")
public class OperatorModulator
extends LXModulator
implements LXNormalizedParameter,
LXOscComponent {
    public final CompoundParameter in1 = new CompoundParameter("In-1", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("First input value");
    public final CompoundParameter in2 = new CompoundParameter("In-2", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Second input value");
    public final EnumParameter<Operation> operation = new EnumParameter<Operation>("Operation", Operation.LERP).setDescription("Operation to apply between inputs");
    public final CompoundParameter amount = new CompoundParameter("Amount", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount to blend from input 1 to the result of the operation");

    public OperatorModulator() {
        this("Operator");
    }

    public OperatorModulator(String label) {
        super(label);
        this.addParameter("in1", this.in1);
        this.addParameter("in2", this.in2);
        this.addParameter("amount", this.amount);
        this.addParameter("operation", this.operation);
    }

    @Override
    protected double computeValue(double deltaMs) {
        return this.operation.getEnum().operate(this.in1.getValue(), this.in2.getValue(), this.amount.getValue());
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("Cannot setNormalized() on OperatorModulator");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    public static enum Operation {
        LERP("Lerp"),
        ADD("Add"),
        SUBTRACT("Subtract"),
        DIFFERENCE("Difference"),
        MULTIPLY("Multiply"),
        DIVIDE("Divide"),
        RATIO("Ratio"),
        MIN("Min"),
        MAX("Max"),
        INVERT("Invert");

        public final String label;

        private Operation(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public double operate(double left, double right, double amount) {
            switch (this) {
                case LERP: {
                    return LXUtils.lerp(left, right, amount);
                }
                case MULTIPLY: {
                    return left * LXUtils.lerp(1.0, right, amount);
                }
                case ADD: {
                    return LXUtils.min(1.0, left + right * amount);
                }
                case SUBTRACT: {
                    return LXUtils.max(0.0, left - right * amount);
                }
                case DIFFERENCE: {
                    return LXUtils.lerp(left, Math.abs(left - right), amount);
                }
                case MIN: {
                    return LXUtils.lerp(left, Math.min(left, right), amount);
                }
                case MAX: {
                    return LXUtils.lerp(left, Math.max(left, right), amount);
                }
                case DIVIDE: {
                    return LXUtils.min(1.0, LXUtils.lerp(left, left / right, amount));
                }
                case RATIO: {
                    double ratio = left < right ? left / right : right / left;
                    return LXUtils.lerp(left, LXUtils.constrain(ratio, 0.0, 1.0), amount);
                }
                case INVERT: {
                    return LXUtils.lerp(left, 1.0 - left, amount);
                }
            }
            return 0.0;
        }
    }
}

