/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.Tempo;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.parameter.QuantizedTriggerParameter;
import heronarts.lx.parameter.TriggerParameter;

@LXModulator.Global(value="Quantizer")
@LXModulator.Device(value="Quantizer")
@LXCategory(value="Trigger")
public class Quantizer
extends LXModulator
implements LXTriggerSource,
LXOscComponent {
    public final ObjectParameter<Tempo.Quantization> quantization = Tempo.newQuantizationParameter("Quantization", "Division to use when quantizing the trigger");
    public final QuantizedTriggerParameter engage;
    public final TriggerParameter triggerOut = new TriggerParameter("Trigger Out").setDescription("Fires when the quantization period has elapsed");

    public Quantizer(LX lx) {
        this(lx, "Quantizer");
    }

    public Quantizer(LX lx, String label) {
        super(label);
        this.engage = new QuantizedTriggerParameter(lx, "Trigger", this.quantization, () -> this.triggerOut.trigger()).setDescription("Engages the quantizer");
        this.addParameter("triggerIn", this.engage);
        this.addParameter("quantization", this.quantization);
        this.addParameter("triggerOut", this.triggerOut);
        this.setDescription("Trigger that is quantied to a tempo division");
        this.setMappingSource(false);
    }

    @Override
    protected double computeValue(double deltaMs) {
        return this.triggerOut.getValue();
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }
}

