/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXSerializable;
import heronarts.lx.midi.LXMidiListener;
import heronarts.lx.midi.MidiNoteOn;
import heronarts.lx.modulator.DampedParameter;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXPeriodicModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.FunctionalParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.MutableParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;

@LXModulator.Global(value="Randomizer")
@LXModulator.Device(value="Randomizer")
@LXCategory(value="Core")
public class Randomizer
extends LXPeriodicModulator
implements LXNormalizedParameter,
LXTriggerSource,
LXMidiListener,
LXOscComponent {
    public final EnumParameter<TriggerMode> triggerMode = new EnumParameter<TriggerMode>("Trig Mode", TriggerMode.INTERNAL).setDescription("Whether triggers are internally or externally generated");
    public final EnumParameter<InterpolationMode> lerpMode = new EnumParameter<InterpolationMode>("Lerp Mode", InterpolationMode.DIRECT).setDescription("How the randomizer moves between values");
    public final CompoundParameter periodMs = new CompoundParameter("Interval", 1000.0, 10.0, 60000.0).setExponent(3.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Base interval for random target value updates");
    public final CompoundParameter randomMs = new CompoundParameter("Random", 0.0, 0.0, 60000.0).setExponent(3.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Range of random time added to each interval");
    public final CompoundParameter chance = new CompoundParameter("Chance", 100.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Chance that the randomizer fires on each interval");
    private double randomInterval = 0.0;
    private final FunctionalParameter totalMs = new FunctionalParameter(){

        @Override
        public double getValue() {
            return Randomizer.this.triggerMode.getEnum() == TriggerMode.EXTERNAL ? Double.POSITIVE_INFINITY : Randomizer.this.periodMs.getValue() + Randomizer.this.randomInterval * Randomizer.this.randomMs.getValue();
        }
    };
    public final CompoundParameter speed = new CompoundParameter("Speed", 5.0, 0.01, 10.0).setExponent(2.0).setDescription("Speed of value update");
    public final CompoundParameter accelTimeSecs = new CompoundParameter("Accel Time", 0.5, 0.0, 5.0).setUnits(LXParameter.Units.SECONDS).setExponent(2.0).setDescription("Number of seconds to accelerate up to speed");
    public final CompoundParameter smoothingWindow = new CompoundParameter("Time", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Smoothing window time");
    public final BoundedParameter smoothingWindowRangeMs = new BoundedParameter("Range", 1000.0, 100.0, 60000.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Range of smoothing window control");
    public final CompoundParameter min = new CompoundParameter("Minimum", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Minimum output value");
    public final CompoundParameter max = new CompoundParameter("Maximum", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Maximum output value");
    public final TriggerParameter triggerIn = new TriggerParameter("Trigger In", this::onTriggerIn).setDescription("Engages the randomizer directly");
    public final TriggerParameter triggerOut = new TriggerParameter("Trigger Out").setDescription("Engages when the randomizer triggers");
    private final MutableParameter target = new MutableParameter(0.5);
    private double smoothedValue = 0.0;
    private final DampedParameter damper = new DampedParameter((LXParameter)this.target, (LXParameter)this.speed, (LXParameter)FunctionalParameter.create(() -> {
        double accelTimeSecs = this.accelTimeSecs.getValue();
        return accelTimeSecs == 0.0 ? 0.0 : this.speed.getValue() / accelTimeSecs;
    }));
    private static final String KEY_LEGACY_ACCEL = "accel";
    private static final String KEY_LEGACY_DAMPING = "damping";

    public Randomizer() {
        this("Random");
    }

    private Randomizer(String label) {
        super(label, null);
        this.midiFilter.enabled.setValue(false);
        this.setPeriod(this.totalMs);
        this.addParameter("triggerMode", this.triggerMode);
        this.addParameter("leprMode", this.lerpMode);
        this.addParameter("periodMs", this.periodMs);
        this.addParameter("randomMs", this.randomMs);
        this.addParameter("chance", this.chance);
        this.addParameter("speed", this.speed);
        this.addParameter("accelTimeSecs", this.accelTimeSecs);
        this.addParameter("smoothingWindow", this.smoothingWindow);
        this.addParameter("smoothingWindowRangeMs", this.smoothingWindowRangeMs);
        this.addParameter("min", this.min);
        this.addParameter("max", this.max);
        this.addParameter("triggerIn", this.triggerIn);
        this.addParameter("triggerOut", this.triggerOut);
        this.damper.start();
        this.setDescription("Random value updated with specified interval and range");
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (LXSerializable.Utils.hasParameter(obj, KEY_LEGACY_ACCEL)) {
            double legacyAccel = LXSerializable.Utils.getParameter(obj, KEY_LEGACY_ACCEL).getAsDouble();
            this.accelTimeSecs.setValue(legacyAccel == 0.0 ? 0.0 : this.speed.getValue() / legacyAccel);
        }
        if (LXSerializable.Utils.hasParameter(obj, KEY_LEGACY_DAMPING) && LXSerializable.Utils.getParameter(obj, KEY_LEGACY_DAMPING).getAsBoolean()) {
            this.lerpMode.setValue((Object)InterpolationMode.DAMPING);
        }
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.triggerMode && this.triggerMode.getEnum() == TriggerMode.EXTERNAL) {
            this.tempoSync.setValue(false);
            this.setBasis(0.0);
        }
    }

    private void onTriggerIn() {
        if (this.running.isOn() && this.triggerMode.getEnum() == TriggerMode.EXTERNAL) {
            this.onManualTrigger(true);
        }
    }

    private void onManualTrigger(boolean resetBasis) {
        if (Math.random() * 100.0 < this.chance.getValue()) {
            this.fire();
            if (resetBasis) {
                this.setBasis(0.0);
            }
        }
    }

    private void fire() {
        this.randomInterval = Math.random();
        this.target.setValue(LXUtils.lerp(this.min.getValue(), this.max.getValue(), Math.random()));
        this.triggerOut.trigger();
    }

    @Override
    protected double computeValue(double deltaMs, double basis) {
        if (this.triggerMode.getEnum() == TriggerMode.INTERNAL && (this.loop() || this.finished()) && Math.random() * 100.0 < this.chance.getValue()) {
            this.fire();
        }
        switch (this.lerpMode.getEnum()) {
            case DAMPING: {
                return LXUtils.constrain(this.damper.getValue(), 0.0, 1.0);
            }
            case SMOOTHING: {
                return this.smoothedValue;
            }
        }
        this.smoothedValue = this.target.getValue();
        return this.smoothedValue;
    }

    @Override
    protected void postRun(double deltaMs) {
        this.damper.loop(deltaMs);
        this.smoothedValue = LXUtils.lerp(this.getValue(), this.target.getValue(), LXUtils.min(1.0, deltaMs / (this.smoothingWindow.getValue() * this.smoothingWindowRangeMs.getValue())));
        switch (this.lerpMode.getEnum()) {
            case DAMPING: {
                this.updateValue(LXUtils.constrain(this.damper.getValue(), 0.0, 1.0));
                break;
            }
            case SMOOTHING: {
                this.updateValue(this.smoothedValue);
                break;
            }
        }
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        this.target.setValue(value);
        return this;
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }

    @Override
    protected double computeBasis(double basis, double value) {
        return 0.0;
    }

    @Override
    public void noteOnReceived(MidiNoteOn note) {
        this.onManualTrigger(false);
    }

    public static enum InterpolationMode {
        DIRECT("Direct"),
        DAMPING("Damped"),
        SMOOTHING("Smooth");

        public final String label;

        private InterpolationMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum TriggerMode {
        INTERNAL("Internal"),
        EXTERNAL("External");

        public final String label;

        private TriggerMode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

