/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXModulator.Global(value="Scaler")
@LXModulator.Device(value="Scaler")
@LXCategory(value="Core")
public class Scaler
extends LXModulator
implements LXOscComponent,
LXNormalizedParameter {
    public final CompoundParameter input = new CompoundParameter("Input", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Input value to the smoother");
    public final EnumParameter<LXParameter.Polarity> inputPolarity = new EnumParameter<LXParameter.Polarity>("Input Polarity", LXParameter.Polarity.UNIPOLAR).setDescription("Input parameter polarity");
    public final EnumParameter<LXParameter.Polarity> gainPolarity = new EnumParameter<LXParameter.Polarity>("Gain Polarity", LXParameter.Polarity.UNIPOLAR).setDescription("Gain polarity");
    public final BoundedParameter gainFactor = new BoundedParameter("Factor", 1.0, -10.0, 10.0).setDescription("Gain range");
    public final CompoundParameter gainUnipolar = new CompoundParameter("Gain", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Gain applied to signal");
    public final CompoundParameter gainBipolar = new CompoundParameter("Gain", 1.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Gain applied to signal");
    public final CompoundParameter offset = new CompoundParameter("Offset", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("DC Offset applied to signal");
    public final CompoundParameter shaping = new CompoundParameter("Shaping", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Shaping applied to signal");
    public final BooleanParameter showPreview = new BooleanParameter("Preview", false).setDescription("Whether the shaper preview is visible in the modulator UI");

    public Scaler() {
        this("Scaler");
    }

    public Scaler(String label) {
        super(label);
        this.addParameter("input", this.input);
        this.addParameter("inputPolarity", this.inputPolarity);
        this.addParameter("gainFactor", this.gainFactor);
        this.addParameter("gainUnipolar", this.gainUnipolar);
        this.addParameter("gainBipolar", this.gainBipolar);
        this.addParameter("gainPolarity", this.gainPolarity);
        this.addParameter("offset", this.offset);
        this.addParameter("shaping", this.shaping);
        this.addParameter("showPreview", this.showPreview);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.inputPolarity) {
            this.input.setPolarity(this.inputPolarity.getEnum());
        }
    }

    public double compute(double input) {
        double shaping = this.shaping.getValue();
        double gain = this.gainFactor.getValue() * (this.gainPolarity.getEnum() == LXParameter.Polarity.UNIPOLAR ? this.gainUnipolar.getValue() : this.gainBipolar.getValue());
        double offset = this.offset.getValue();
        double exponent = 0.0;
        double maxShape = 2.0;
        if (shaping > 0.0) {
            exponent = 1.0 + 2.0 * shaping;
        } else if (shaping < 0.0) {
            exponent = 1.0 - 2.0 * shaping;
        }
        switch (this.inputPolarity.getEnum()) {
            case UNIPOLAR: {
                input = gain >= 0.0 ? (input *= gain) : LXUtils.lerp(0.0, 1.0 - input, -gain);
                input = LXUtils.constrain(input + offset, 0.0, 1.0);
                if (shaping > 0.0) {
                    input = Math.pow(input, exponent);
                    break;
                }
                if (!(shaping < 0.0)) break;
                input = 1.0 - Math.pow(1.0 - input, exponent);
                break;
            }
            case BIPOLAR: {
                input = 0.5 + (input - 0.5) * gain;
                input = LXUtils.constrain(input + offset, 0.0, 1.0);
                if (shaping > 0.0) {
                    if (input > 0.5) {
                        input = 0.5 + 0.5 * Math.pow(2.0 * (input - 0.5), exponent);
                        break;
                    }
                    if (!(input < 0.5)) break;
                    input = 0.5 - 0.5 * Math.pow(1.0 - 2.0 * input, exponent);
                    break;
                }
                if (!(shaping < 0.0)) break;
                if (input > 0.5) {
                    input = 1.0 - 0.5 * Math.pow(2.0 * (1.0 - input), exponent);
                    break;
                }
                if (!(input < 0.5)) break;
                input = 0.5 * Math.pow(2.0 * input, exponent);
            }
        }
        return input;
    }

    @Override
    protected double computeValue(double deltaMs) {
        return this.compute(this.input.getValue());
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new IllegalArgumentException("Cannot setNormalized() on Scaler");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }
}

