/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXModulator.Global(value="Smoother")
@LXModulator.Device(value="Smoother")
@LXCategory(value="Core")
public class Smoother
extends LXModulator
implements LXOscComponent,
LXNormalizedParameter {
    public final CompoundParameter input = new CompoundParameter("Input", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Input value to the smoother");
    public final CompoundParameter window = new CompoundParameter("Time", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Smoothing window time");
    public final BoundedParameter windowRangeMs = new BoundedParameter("Range", 1000.0, 100.0, 60000.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Range of smoothing window control");

    public Smoother() {
        this("Smoother");
    }

    public Smoother(String label) {
        super(label);
        this.addParameter("input", this.input);
        this.addParameter("window", this.window);
        this.addParameter("windowRangeMs", this.windowRangeMs);
    }

    @Override
    protected double computeValue(double deltaMs) {
        return LXUtils.lerp(this.getValue(), this.input.getValue(), LXUtils.min(1.0, deltaMs / (this.window.getValue() * this.windowRangeMs.getValue())));
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("May not setNormalized() on Smoother");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }
}

