/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

@LXModulator.Global(value="Spring")
@LXModulator.Device(value="Spring")
@LXCategory(value="Core")
public class Spring
extends LXModulator
implements LXOscComponent,
LXNormalizedParameter {
    public final CompoundParameter position = new CompoundParameter("Position", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Position of the spring");
    public final CompoundParameter tension = new CompoundParameter("Tension", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Tension of the spring");
    public final CompoundParameter friction = new CompoundParameter("Friction", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Friction of the spring");
    public final CompoundParameter bounce = new CompoundParameter("Bounce", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Bounce coefficiant if the spring strikes the end of its bounds");
    private double velocity = 0.0;

    public Spring() {
        this("Spring");
    }

    public Spring(String label) {
        super(label);
        this.addParameter("position", this.position);
        this.addParameter("tension", this.tension);
        this.addParameter("friction", this.friction);
        this.addParameter("bounce", this.bounce);
    }

    @Override
    protected double computeValue(double deltaMs) {
        double timeStep = deltaMs / 1000.0;
        double position = this.getValue();
        double distance = position - this.position.getValue();
        double tension = this.tension.getValue() * 100.0;
        double friction = this.friction.getValue() * 10.0;
        double accel = -tension * distance - friction * this.velocity;
        this.velocity += accel * timeStep;
        if ((position += timeStep * (this.velocity + 0.5 * accel * timeStep)) < 0.0 || position > 1.0) {
            position = LXUtils.constrain(position, 0.0, 1.0);
            this.velocity = -this.velocity * this.bounce.getValue();
        }
        return position;
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("May not setNormalized() on Spring");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }
}

