/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXTriggerSource;
import heronarts.lx.modulator.StepModulator;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;

@LXModulator.Global(value="Stepper")
@LXModulator.Device(value="Stepper")
@LXCategory(value="Core")
public class Stepper
extends StepModulator
implements LXNormalizedParameter,
LXTriggerSource,
LXOscComponent {
    public final BoundedParameter[] steps = new BoundedParameter[16];

    public Stepper() {
        super("Stepper");
        int i = 0;
        while (i < this.steps.length) {
            this.steps[i] = new BoundedParameter("Step-" + (i + 1)).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Stepper value on step " + (i + 1));
            this.addParameter("step-" + (i + 1), this.steps[i]);
            ++i;
        }
        this.setDescription("Step modulator that changes values on trigger events");
    }

    @Override
    protected void onStep(boolean trigger) {
        if (trigger) {
            this.triggerOut.trigger();
        }
    }

    @Override
    public LXNormalizedParameter setNormalized(double value) {
        throw new UnsupportedOperationException("Stepper does not support setNormalized()");
    }

    @Override
    public double getNormalized() {
        return this.getValue();
    }

    @Override
    protected double getStepValue(double deltaMs, double basis) {
        return this.steps[this.step].getValue();
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.triggerOut;
    }
}

