/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.modulator;

import heronarts.lx.LXCategory;
import heronarts.lx.modulator.LXModulator;
import heronarts.lx.modulator.LXVariablePeriodModulator;
import heronarts.lx.modulator.LXWaveshape;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;

@LXCategory(value="Core")
@LXModulator.Global(value="LFO")
@LXModulator.Device(value="LFO")
public class VariableLFO
extends LXVariablePeriodModulator
implements LXWaveshape,
LXOscComponent {
    public final ObjectParameter<LXWaveshape> waveshape;
    public final CompoundParameter periodCustom;
    public final CompoundParameter skew = new CompoundParameter("Skew", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Sets a skew coefficient for the waveshape").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter shape = new CompoundParameter("Shape", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Applies shaping to the waveshape").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter exp = new CompoundParameter("Exp", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Applies exponential scaling to the waveshape").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter bias = new CompoundParameter("Bias", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Bias towards or away from the center of the waveform").setPolarity(LXParameter.Polarity.BIPOLAR);
    public final CompoundParameter phase = new CompoundParameter("Phase", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Shifts the phase of the waveform");

    public VariableLFO() {
        this("LFO", null, null);
    }

    public VariableLFO(String label) {
        this(label, null, null);
    }

    public VariableLFO(String label, LXWaveshape[] waveshapes) {
        this(label, waveshapes, null);
    }

    public VariableLFO(String label, LXWaveshape[] waveshapes, CompoundParameter period) {
        super(label, new FixedParameter(0.0), new FixedParameter(1.0), new FixedParameter(1000.0));
        if (waveshapes == null) {
            waveshapes = new LXWaveshape[]{LXWaveshape.SIN, LXWaveshape.TRI, LXWaveshape.SQUARE, LXWaveshape.UP, LXWaveshape.DOWN};
        }
        this.waveshape = new ObjectParameter<LXWaveshape>("Wave", waveshapes);
        this.waveshape.setDescription("Selects the wave shape used by this LFO");
        if (period != null) {
            this.periodCustom = period;
            this.addParameter("period", this.periodCustom);
            this.setPeriod(this.periodCustom);
        } else {
            this.periodCustom = null;
            this.setPeriod(this.periodFast);
        }
        this.addParameter("wave", this.waveshape);
        this.addParameter("skew", this.skew);
        this.addParameter("shape", this.shape);
        this.addParameter("bias", this.bias);
        this.addParameter("phase", this.phase);
        this.addParameter("exp", this.exp);
    }

    public LXWaveshape getWaveshape() {
        return this.waveshape.getObject();
    }

    @Override
    protected final double computeNormalizedValue(double deltaMs, double basis) {
        return this.compute(basis);
    }

    @Override
    protected final double computeNormalizedBasis(double basis, double normalizedValue) {
        return this.invert(normalizedValue, basis);
    }

    @Override
    public double compute(double basis) {
        return this.compute(basis, this.phase.getValue(), this.bias.getValue(), this.skew.getValue(), this.shape.getValue(), this.exp.getValue());
    }

    public double computeBase(double basis) {
        return this.compute(basis, this.phase.getBaseValue(), this.bias.getBaseValue(), this.skew.getBaseValue(), this.shape.getBaseValue(), this.exp.getBaseValue());
    }

    private double compute(double basis, double phase, double bias, double skew, double shape, double exp) {
        double expPower;
        double shapePower;
        double skewPower;
        if ((basis += phase) > 1.0) {
            basis %= 1.0;
        }
        if (bias != 0.0) {
            double biasPower = 1.0 + 3.0 * Math.abs(bias);
            double midp = 0.25 - 0.15 * bias;
            double midInv = 1.0 / midp;
            double midAlt = 0.5 - midp;
            double midAltInv = 1.0 / midAlt;
            basis = basis < midp ? midp * Math.pow(midInv * basis, biasPower) : (basis < 0.5 ? 0.5 - midAlt * Math.pow(midAltInv * (0.5 - basis), biasPower) : (basis < 0.5 + midAlt ? 0.5 + midAlt * Math.pow(midAltInv * (basis - 0.5), biasPower) : 1.0 - midp * Math.pow(midInv * (1.0 - basis), biasPower)));
        }
        double d = skewPower = skew >= 0.0 ? 1.0 + 3.0 * skew : 1.0 / (1.0 - 3.0 * skew);
        if (skewPower != 1.0) {
            basis = Math.pow(basis, skewPower);
        }
        double value = this.getWaveshape().compute(basis);
        double d2 = shapePower = shape <= 0.0 ? 1.0 - 3.0 * shape : 1.0 / (1.0 + 3.0 * shape);
        if (shapePower != 1.0) {
            value = value >= 0.5 ? 0.5 + 0.5 * Math.pow(2.0 * (value - 0.5), shapePower) : 0.5 - 0.5 * Math.pow(2.0 * (0.5 - value), shapePower);
        }
        double d3 = expPower = exp >= 0.0 ? 1.0 + 3.0 * exp : 1.0 / (1.0 - 3.0 * exp);
        if (expPower != 1.0) {
            value = Math.pow(value, expPower);
        }
        return value;
    }

    @Override
    public double invert(double value, double basisHint) {
        return this.getWaveshape().invert(value, basisHint);
    }
}

