/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.osc.LXOscEngine;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public abstract class LXOscConnection
extends LXComponent {
    public static final String DEFAULT_INPUT_HOST = "0.0.0.0";
    public static final String DEFAULT_OUTPUT_HOST = "localhost";
    private final boolean isInput = this instanceof Input;
    private final String prefix = this.isInput ? "RX" : "TX";
    public final BooleanParameter active = new BooleanParameter(this.prefix + " Active", false).setMappable(false).setDescription(this.isInput ? "Enables or disables OSC engine input" : "Enables or disables OSC engine output");
    public final StringParameter host = new StringParameter(this.prefix + " Host", this.isInput ? "0.0.0.0" : "localhost").setMappable(false).setDescription(this.isInput ? "Hostname to which OSC input socket is bound" : "Hostname to which OSC messages are sent");
    public final BooleanParameter hasFilter = new BooleanParameter("Has Filter", false).setDescription("Whether prefix filtering is applied to OSC messages");
    public final StringParameter filter = new StringParameter("Filter", "/lx").setDescription("Filter OSC messages on matching prefix");
    public final DiscreteParameter port = new DiscreteParameter(this.prefix + " Port", this.isInput ? this._defaultInputPort() : this._defaultOutputPort(), 1, 65535).setMappable(false).setUnits(LXParameter.Units.INTEGER).setDescription(this.isInput ? "UDP port on which the engine listens for OSC messages" : "UDP port on which the engine transmits OSC messages");
    public final BooleanParameter log = new BooleanParameter(this.prefix + " Log", false).setDescription(this.isInput ? "Whether to log OSC input messages" : "Whether to log OSC output messages");
    public final BooleanParameter unknownHost = new BooleanParameter("Unknown Host", false).setMappable(false).setDescription(this.isInput ? "Set to true if the receive host is unknown" : "Set to true if the transmit host is unknown");
    public final EnumParameter<LXOscEngine.IOState> state = ((EnumParameter)new EnumParameter<LXOscEngine.IOState>(this.prefix + " State", LXOscEngine.IOState.STOPPED).setMappable(false)).setDescription("The state of the OSC connection");
    public final TriggerParameter activity = new TriggerParameter(this.prefix + " Activity").setMappable(false).setDescription("Triggers when there is activity on the OSC connection");

    private int _defaultInputPort() {
        int max = this.lx.engine.osc.receivePort.getValuei();
        for (LXOscConnection lXOscConnection : this.lx.engine.osc.inputs) {
            max = LXUtils.max(max, lXOscConnection.port.getValuei());
        }
        return max + 1;
    }

    private int _defaultOutputPort() {
        int max = this.lx.engine.osc.transmitPort.getValuei();
        for (LXOscConnection lXOscConnection : this.lx.engine.osc.outputs) {
            max = LXUtils.max(max, lXOscConnection.port.getValuei());
        }
        return max + 1;
    }

    LXOscConnection(LX lx) {
        super(lx);
        this.addParameter("host", this.host);
        this.addParameter("port", this.port);
        this.addParameter("log", this.log);
        this.addParameter("hasFilter", this.hasFilter);
        this.addParameter("filter", this.filter);
        this.addParameter("active", this.active);
    }

    protected String getFilter() {
        return this.hasFilter.isOn() ? this.filter.getString() : null;
    }

    public static class Input
    extends LXOscConnection {
        private LXOscEngine.Receiver receiver;

        Input(LX lx) {
            super(lx);
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            super.onParameterChanged(p);
            if (p == this.port) {
                if (this.active.isOn()) {
                    this.startReceiver();
                }
            } else if (p == this.host) {
                try {
                    InetAddress.getByName(this.host.getString());
                    this.unknownHost.setValue(false);
                    if (this.active.isOn()) {
                        this.startReceiver();
                    }
                }
                catch (UnknownHostException uhx) {
                    LXOscEngine.error("Invalid OSC receive host: " + uhx.getLocalizedMessage());
                    this.unknownHost.setValue(true);
                    this.stopReceiver(LXOscEngine.IOState.UNKNOWN_HOST);
                }
            } else if (p == this.active) {
                if (this.active.isOn()) {
                    this.startReceiver();
                } else {
                    this.stopReceiver(LXOscEngine.IOState.STOPPED);
                }
            }
        }

        private void startReceiver() {
            if (this.receiver != null) {
                this.stopReceiver(LXOscEngine.IOState.STOPPED);
            }
            String host = this.host.getString();
            int port = this.port.getValuei();
            try {
                this.state.setValue((Object)LXOscEngine.IOState.BINDING);
                this.receiver = this.lx.engine.osc.receiver(port, host);
                this.receiver.setConnection(this);
                this.receiver.addListener(this.lx.engine.osc.engineListener);
                this.unknownHost.setValue(false);
                this.state.setValue((Object)LXOscEngine.IOState.BOUND);
                LXOscEngine.log("Started OSC listener " + String.valueOf(this.receiver.address));
            }
            catch (UnknownHostException uhx) {
                LXOscEngine.error("Bad OSC receive host: " + uhx.getLocalizedMessage());
                this.unknownHost.setValue(true);
                this.stopReceiver(LXOscEngine.IOState.UNKNOWN_HOST);
            }
            catch (SocketException sx) {
                LXOscEngine.error("Failed to start OSC receiver: " + sx.getLocalizedMessage());
                this.lx.pushError(sx, "Failed to start OSC receiver at " + host + ":" + port + "\n" + sx.getLocalizedMessage());
                this.stopReceiver(LXOscEngine.IOState.SOCKET_ERROR);
            }
        }

        private void stopReceiver(LXOscEngine.IOState state) {
            if (this.receiver != null) {
                this.receiver.stop();
                this.receiver = null;
            }
            this.state.setValue((Object)state);
        }

        @Override
        public void dispose() {
            this.stopReceiver(LXOscEngine.IOState.STOPPED);
            super.dispose();
        }
    }

    public static class Output
    extends LXOscConnection {
        LXOscEngine.EngineTransmitter transmitter;

        Output(LX lx) {
            super(lx);
        }

        @Override
        public void onParameterChanged(LXParameter p) {
            super.onParameterChanged(p);
            if (p == this.port) {
                if (this.transmitter != null) {
                    this.transmitter.setPort(this.port.getValuei());
                }
            } else if (p == this.host) {
                try {
                    InetAddress address = InetAddress.getByName(this.host.getString());
                    this.unknownHost.setValue(false);
                    if (this.transmitter != null) {
                        this.transmitter.setAddress(address);
                        this.state.setValue((Object)LXOscEngine.IOState.BOUND);
                    }
                }
                catch (UnknownHostException uhx) {
                    LXOscEngine.error("Invalid OSC output host: " + uhx.getLocalizedMessage());
                    this.unknownHost.setValue(true);
                    this.state.setValue((Object)LXOscEngine.IOState.UNKNOWN_HOST);
                }
            } else if (p == this.active) {
                if (this.active.isOn()) {
                    if (this.unknownHost.isOn()) {
                        this.state.setValue((Object)LXOscEngine.IOState.UNKNOWN_HOST);
                    } else {
                        this.startTransmitter();
                    }
                } else {
                    this.state.setValue((Object)LXOscEngine.IOState.STOPPED);
                }
            }
        }

        private void startTransmitter() {
            if (this.transmitter == null) {
                String host = this.host.getString();
                int port = this.port.getValuei();
                try {
                    this.state.setValue((Object)LXOscEngine.IOState.BINDING);
                    InetAddress address = InetAddress.getByName(host);
                    this.unknownHost.setValue(false);
                    this.transmitter = this.lx.engine.osc.transmitter(address, port, this);
                    this.transmitter.setConnection(this);
                    this.state.setValue((Object)LXOscEngine.IOState.BOUND);
                }
                catch (UnknownHostException uhx) {
                    LXOscEngine.error("Invalid host: " + uhx.getLocalizedMessage());
                    this.unknownHost.setValue(true);
                    this.state.setValue((Object)LXOscEngine.IOState.UNKNOWN_HOST);
                }
                catch (SocketException sx) {
                    LXOscEngine.error("Could not start transmitter: " + sx.getLocalizedMessage());
                    this.lx.pushError(sx, "Failed to start OSC transmitter at " + host + ":" + port + "\n" + sx.getLocalizedMessage());
                    this.state.setValue((Object)LXOscEngine.IOState.SOCKET_ERROR);
                }
            } else {
                this.state.setValue((Object)LXOscEngine.IOState.BOUND);
            }
        }

        @Override
        public void dispose() {
            if (this.transmitter != null) {
                this.transmitter.dispose();
            }
            super.dispose();
        }
    }
}

