/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXComponent;
import heronarts.lx.LXSerializable;
import heronarts.lx.color.ColorParameter;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.osc.LXOscConnection;
import heronarts.lx.osc.LXOscListener;
import heronarts.lx.osc.LXOscQueryServer;
import heronarts.lx.osc.OscBundle;
import heronarts.lx.osc.OscException;
import heronarts.lx.osc.OscFloat;
import heronarts.lx.osc.OscInt;
import heronarts.lx.osc.OscMessage;
import heronarts.lx.osc.OscPacket;
import heronarts.lx.osc.OscString;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.parameter.TriggerParameter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

public class LXOscEngine
extends LXComponent {
    public static final int DEFAULT_RECEIVE_PORT = 3030;
    public static final int DEFAULT_TRANSMIT_PORT = 4040;
    public static final String DEFAULT_RECEIVE_HOST = "0.0.0.0";
    public static final String DEFAULT_TRANSMIT_HOST = "localhost";
    private static final int DEFAULT_MAX_PACKET_SIZE = 8192;
    public final BooleanParameter receiveActive = new BooleanParameter("RX Active", false).setMappable(false).setDescription("Enables or disables OSC engine input");
    public final StringParameter receiveHost = new StringParameter("RX Host", "0.0.0.0").setDescription("Hostname to which OSC input socket is bound");
    public final BooleanParameter unknownReceiveHost = new BooleanParameter("Unknown RX Host", false).setMappable(false).setDescription("Set to true if the receive host is unknown");
    public final EnumParameter<IOState> receiveState = ((EnumParameter)new EnumParameter<IOState>("RX State", IOState.STOPPED).setMappable(false)).setDescription("The state of the OSC receiver");
    public final TriggerParameter receiveActivity = new TriggerParameter("RX Activity").setMappable(false).setDescription("Triggers when OSC data is received");
    public final DiscreteParameter receivePort = new DiscreteParameter("RX Port", 3030, 1, 65535).setDescription("UDP port on which the engine listens for OSC messages").setMappable(false).setUnits(LXParameter.Units.INTEGER);
    public final BooleanParameter transmitActive = new BooleanParameter("TX Active", false).setMappable(false).setDescription("Enables or disables OSC engine output");
    public final StringParameter transmitHost = new StringParameter("TX Host", "localhost").setMappable(false).setDescription("Hostname to which OSC messages are sent");
    public final BooleanParameter unknownTransmitHost = new BooleanParameter("Unknown TX Host", false).setMappable(false).setDescription("Set to true if the transmit host is unknown");
    public final EnumParameter<IOState> transmitState = ((EnumParameter)new EnumParameter<IOState>("TX State", IOState.STOPPED).setMappable(false)).setDescription("The state of the OSC transmitter");
    public final TriggerParameter transmitActivity = new TriggerParameter("TX Activity").setMappable(false).setDescription("Triggers when OSC data is sent");
    public final DiscreteParameter transmitPort = new DiscreteParameter("TX Port", 4040, 1, 65535).setDescription("UDP port on which the engine transmits OSC messages").setMappable(false).setUnits(LXParameter.Units.INTEGER);
    public final BooleanParameter logInput = new BooleanParameter("RX Log", false).setDescription("Whether to log OSC input messages");
    public final BooleanParameter logOutput = new BooleanParameter("TX Log", false).setDescription("Whether to log OSC output messages");
    private final List<Receiver> receivers = new CopyOnWriteArrayList<Receiver>();
    private Receiver engineReceiver;
    final EngineListener engineListener = new EngineListener();
    private EngineTransmitter engineTransmitter;
    private final List<IOListener> ioListeners = new ArrayList<IOListener>();
    private final List<LXOscListener> listeners = new ArrayList<LXOscListener>();
    private final LXOscQueryServer oscQueryServer;
    private final Zeroconf zeroconf;
    private final List<LXOscConnection.Input> mutableInputs = new ArrayList<LXOscConnection.Input>();
    public final List<LXOscConnection.Input> inputs = Collections.unmodifiableList(this.mutableInputs);
    private final List<LXOscConnection.Output> mutableOutputs = new ArrayList<LXOscConnection.Output>();
    public final List<LXOscConnection.Output> outputs = Collections.unmodifiableList(this.mutableOutputs);
    private static final String KEY_INPUTS = "inputs";
    private static final String KEY_OUTPUTS = "outputs";
    private static final String OSC_LOG_PREFIX = "[OSC] ";

    public LXOscEngine(LX lx) {
        super(lx, "OSC");
        if (lx.flags.zeroconf) {
            this.oscQueryServer = new LXOscQueryServer(lx);
            this.zeroconf = Zeroconf.create(lx.flags.zeroconfServiceName);
        } else {
            this.oscQueryServer = null;
            this.zeroconf = null;
        }
        this.addParameter("receiveHost", this.receiveHost);
        this.addParameter("receivePort", this.receivePort);
        this.addParameter("receiveActive", this.receiveActive);
        this.addParameter("transmitHost", this.transmitHost);
        this.addParameter("transmitPort", this.transmitPort);
        this.addParameter("transmitActive", this.transmitActive);
        this.addParameter("logInput", this.logInput);
        this.addParameter("logOutput", this.logOutput);
        this.addArray(KEY_INPUTS, this.inputs);
        this.addArray(KEY_OUTPUTS, this.outputs);
    }

    public LXOscEngine addIOListener(IOListener listener) {
        Objects.requireNonNull("May not add null IOListener");
        if (this.ioListeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXOscEngine.IOListener: " + String.valueOf(listener));
        }
        this.ioListeners.add(listener);
        return this;
    }

    public LXOscEngine removeIOListener(IOListener listener) {
        if (!this.ioListeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent LXOscEngine.IOListener: " + String.valueOf(listener));
        }
        this.ioListeners.remove(listener);
        return this;
    }

    public LXOscEngine addListener(LXOscListener listener) {
        Objects.requireNonNull("May not add null LXOscListener");
        if (this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot add duplicate LXOscEngine.LXOscListener: " + String.valueOf(listener));
        }
        this.listeners.add(listener);
        return this;
    }

    public LXOscEngine removeListener(LXOscListener listener) {
        if (!this.listeners.contains(listener)) {
            throw new IllegalStateException("Cannot remove non-existent LXOscEngine.LXOscListener: " + String.valueOf(listener));
        }
        this.listeners.remove(listener);
        return this;
    }

    public LXOscEngine sendMessage(String path, int value) {
        if (this.engineTransmitter != null) {
            this.engineTransmitter.sendMessage(path, value);
        }
        for (LXOscConnection.Output output : this.outputs) {
            if (output.transmitter == null) continue;
            output.transmitter.sendMessage(path, value);
        }
        return this;
    }

    public LXOscEngine sendMessage(String path, float value) {
        if (this.engineTransmitter != null) {
            this.engineTransmitter.sendMessage(path, value);
        }
        for (LXOscConnection.Output output : this.outputs) {
            if (output.transmitter == null) continue;
            output.transmitter.sendMessage(path, value);
        }
        return this;
    }

    public LXOscEngine sendMessage(String path, String value) {
        if (this.engineTransmitter != null) {
            this.engineTransmitter.sendMessage(path, value);
        }
        for (LXOscConnection.Output output : this.outputs) {
            if (output.transmitter == null) continue;
            output.transmitter.sendMessage(path, value);
        }
        return this;
    }

    public LXOscEngine sendParameter(LXParameter parameter) {
        if (this.engineTransmitter != null) {
            this.engineTransmitter.onParameterChanged(parameter);
        }
        for (LXOscConnection.Output output : this.outputs) {
            if (output.transmitter == null) continue;
            output.transmitter.onParameterChanged(parameter);
        }
        return this;
    }

    public static String getOscAddress(LXParameter p) {
        String componentAddress;
        if (p instanceof LXOscComponent) {
            return ((LXOscComponent)((Object)p)).getOscAddress();
        }
        LXComponent component = p.getParent();
        if (component instanceof LXOscComponent && component.isValidOscParameter(p) && (componentAddress = component.getOscAddress()) != null) {
            return componentAddress + "/" + p.getPath();
        }
        return null;
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        if (p == this.receivePort) {
            if (this.receiveActive.isOn()) {
                this.startReceiver();
            }
        } else if (p == this.receiveHost) {
            try {
                InetAddress.getByName(this.receiveHost.getString());
                this.unknownReceiveHost.setValue(false);
                if (this.receiveActive.isOn()) {
                    this.startReceiver();
                }
            }
            catch (UnknownHostException uhx) {
                LXOscEngine.error("Invalid OSC receive host: " + uhx.getLocalizedMessage());
                this.unknownReceiveHost.setValue(true);
                this.stopReceiver(IOState.UNKNOWN_HOST);
            }
        } else if (p == this.receiveActive) {
            if (this.receiveActive.isOn()) {
                this.startReceiver();
            } else {
                this.stopReceiver(IOState.STOPPED);
            }
        } else if (p == this.transmitPort) {
            if (this.engineTransmitter != null) {
                this.engineTransmitter.setPort(this.transmitPort.getValuei());
            }
        } else if (p == this.transmitHost) {
            try {
                InetAddress address = InetAddress.getByName(this.transmitHost.getString());
                this.unknownTransmitHost.setValue(false);
                if (this.engineTransmitter != null) {
                    this.engineTransmitter.setAddress(address);
                    this.transmitState.setValue((Object)IOState.BOUND);
                }
            }
            catch (UnknownHostException uhx) {
                LXOscEngine.error("Invalid OSC output host: " + uhx.getLocalizedMessage());
                this.unknownTransmitHost.setValue(true);
                this.transmitState.setValue((Object)IOState.UNKNOWN_HOST);
            }
        } else if (p == this.transmitActive) {
            if (this.transmitActive.isOn()) {
                if (this.unknownTransmitHost.isOn()) {
                    this.transmitState.setValue((Object)IOState.UNKNOWN_HOST);
                } else {
                    this.startTransmitter();
                }
            } else {
                this.transmitState.setValue((Object)IOState.STOPPED);
            }
        }
    }

    private void startReceiver() {
        if (this.engineReceiver != null) {
            this.stopReceiver(IOState.STOPPED);
        }
        String host = this.receiveHost.getString();
        int port = this.receivePort.getValuei();
        try {
            this.receiveState.setValue((Object)IOState.BINDING);
            this.engineReceiver = this.receiver(port, host);
            this.engineReceiver.setLog(this.logInput);
            this.engineReceiver.setActivity(this.receiveActivity);
            this.engineReceiver.addListener(this.engineListener);
            this.unknownReceiveHost.setValue(false);
            this.receiveState.setValue((Object)IOState.BOUND);
            LXOscEngine.log("Started OSC listener " + String.valueOf(this.engineReceiver.address));
            if (this.oscQueryServer != null) {
                this.oscQueryServer.bind(port);
            }
            if (this.zeroconf != null) {
                this.zeroconf.register(port);
            }
        }
        catch (UnknownHostException uhx) {
            LXOscEngine.error("Bad OSC receive host: " + uhx.getLocalizedMessage());
            this.unknownReceiveHost.setValue(true);
            this.stopReceiver(IOState.UNKNOWN_HOST);
        }
        catch (SocketException sx) {
            LXOscEngine.error("Failed to start OSC receiver: " + sx.getLocalizedMessage());
            this.lx.pushError(sx, "Failed to start OSC receiver at " + host + ":" + port + "\n" + sx.getLocalizedMessage());
            this.stopReceiver(IOState.SOCKET_ERROR);
        }
    }

    private void stopReceiver(IOState state) {
        if (this.engineReceiver != null) {
            this.engineReceiver.stop();
            this.engineReceiver = null;
        }
        if (this.oscQueryServer != null) {
            this.oscQueryServer.unbind();
        }
        if (this.zeroconf != null) {
            this.zeroconf.unregister();
        }
        this.receiveState.setValue((Object)state);
    }

    private void startTransmitter() {
        if (this.engineTransmitter == null) {
            String host = this.transmitHost.getString();
            int port = this.transmitPort.getValuei();
            try {
                this.transmitState.setValue((Object)IOState.BINDING);
                InetAddress address = InetAddress.getByName(host);
                this.unknownTransmitHost.setValue(false);
                this.engineTransmitter = new EngineTransmitter(address, port, 8192);
                this.transmitState.setValue((Object)IOState.BOUND);
            }
            catch (UnknownHostException uhx) {
                LXOscEngine.error("Invalid host: " + uhx.getLocalizedMessage());
                this.unknownTransmitHost.setValue(true);
                this.transmitState.setValue((Object)IOState.UNKNOWN_HOST);
            }
            catch (SocketException sx) {
                LXOscEngine.error("Could not start transmitter: " + sx.getLocalizedMessage());
                this.lx.pushError(sx, "Failed to start OSC transmitter at " + host + ":" + port + "\n" + sx.getLocalizedMessage());
                this.transmitState.setValue((Object)IOState.SOCKET_ERROR);
            }
        } else {
            this.transmitState.setValue((Object)IOState.BOUND);
        }
    }

    public Receiver receiver(int port, String host) throws SocketException, UnknownHostException {
        return this.receiver(port, InetAddress.getByName(host));
    }

    public Receiver receiver(int port, InetAddress address) throws SocketException {
        return this.receiver(port, address, 8192);
    }

    public Receiver receiver(int port, InetAddress address, int bufferSize) throws SocketException {
        Receiver receiver = new Receiver(port, address, bufferSize);
        this.receivers.add(receiver);
        return receiver;
    }

    public Receiver receiver(int port) throws SocketException {
        return this.receiver(port, 8192);
    }

    public Receiver receiver(int port, int bufferSize) throws SocketException {
        Receiver receiver = new Receiver(port, bufferSize);
        this.receivers.add(receiver);
        return receiver;
    }

    public Transmitter transmitter(String host, int port) throws SocketException, UnknownHostException {
        return this.transmitter(InetAddress.getByName(host), port);
    }

    public Transmitter transmitter(InetAddress address, int port) throws SocketException {
        return this.transmitter(address, port, 8192);
    }

    public Transmitter transmitter(InetAddress address, int port, int bufferSize) throws SocketException {
        return new Transmitter(address, port, bufferSize);
    }

    EngineTransmitter transmitter(InetAddress address, int port, LXOscConnection.Output output) throws SocketException {
        return new EngineTransmitter(address, port, 8192, output);
    }

    public LXOscConnection.Input addInput() {
        return this.addInput(new LXOscConnection.Input(this.lx));
    }

    public LXOscConnection.Input addInput(LXOscConnection.Input input) {
        return this.addInput(input, -1);
    }

    public LXOscConnection.Input addInput(JsonObject inputObj, int index) {
        LXOscConnection.Input input = new LXOscConnection.Input(this.lx);
        input.load(this.lx, inputObj);
        return this.addInput(input, index);
    }

    public LXOscConnection.Input addInput(LXOscConnection.Input input, int index) {
        if (index < 0) {
            this.mutableInputs.add(input);
        } else {
            this.mutableInputs.add(index, input);
        }
        for (IOListener listener : this.ioListeners) {
            listener.inputAdded(this, input);
        }
        return input;
    }

    public LXOscEngine removeInput(LXOscConnection.Input input) {
        if (!this.inputs.contains(input)) {
            throw new IllegalStateException("Cannot remove input not in OSC engine: " + String.valueOf(input));
        }
        this.mutableInputs.remove(input);
        for (IOListener listener : this.ioListeners) {
            listener.inputRemoved(this, input);
        }
        LX.dispose(input);
        return this;
    }

    public LXOscConnection.Output addOutput() {
        return this.addOutput(new LXOscConnection.Output(this.lx));
    }

    public LXOscConnection.Output addOutput(LXOscConnection.Output output) {
        return this.addOutput(output, -1);
    }

    public LXOscConnection.Output addOutput(JsonObject outputObj, int index) {
        LXOscConnection.Output output = new LXOscConnection.Output(this.lx);
        output.load(this.lx, outputObj);
        return this.addOutput(output, index);
    }

    public LXOscConnection.Output addOutput(LXOscConnection.Output output, int index) {
        if (index < 0) {
            this.mutableOutputs.add(output);
        } else {
            this.mutableOutputs.add(index, output);
        }
        for (IOListener listener : this.ioListeners) {
            listener.outputAdded(this, output);
        }
        return output;
    }

    public LXOscEngine removeOutput(LXOscConnection.Output output) {
        if (!this.outputs.contains(output)) {
            throw new IllegalStateException("Cannot remove output not in OSC engine: " + String.valueOf(output));
        }
        this.mutableOutputs.remove(output);
        for (IOListener listener : this.ioListeners) {
            listener.outputRemoved(this, output);
        }
        LX.dispose(output);
        return this;
    }

    public void dispatch() {
        for (Receiver receiver : this.receivers) {
            receiver.dispatch();
        }
    }

    private void disposeIO() {
        for (LXOscConnection.Input input : this.inputs) {
            LX.dispose(input);
        }
        this.mutableInputs.clear();
        for (LXOscConnection.Output output : this.outputs) {
            LX.dispose(output);
        }
        this.mutableOutputs.clear();
    }

    private void removeIO() {
        int i = this.inputs.size() - 1;
        while (i >= 0) {
            this.removeInput(this.inputs.get(i));
            --i;
        }
        i = this.outputs.size() - 1;
        while (i >= 0) {
            this.removeOutput(this.outputs.get(i));
            --i;
        }
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_INPUTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.inputs));
        obj.add(KEY_OUTPUTS, (JsonElement)LXSerializable.Utils.toArray(lx, this.outputs));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has("_reset_")) {
            this.receiveActive.setValue(false);
            this.transmitActive.setValue(false);
            this.receivePort.reset();
            this.transmitPort.reset();
            this.receiveHost.reset();
            this.transmitHost.reset();
        }
        this.removeIO();
        if (obj.has(KEY_INPUTS)) {
            JsonArray inputArr = obj.get(KEY_INPUTS).getAsJsonArray();
            for (JsonElement inputElem : inputArr) {
                this.addInput(inputElem.getAsJsonObject(), -1);
            }
        }
        if (obj.has(KEY_OUTPUTS)) {
            JsonArray outputArr = obj.get(KEY_OUTPUTS).getAsJsonArray();
            for (JsonElement outputElem : outputArr) {
                this.addOutput(outputElem.getAsJsonObject(), -1);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.listeners.forEach(listener -> LX.warning("Stranged LXOscEngine.Listener: " + String.valueOf(listener)));
        this.listeners.clear();
        if (this.engineTransmitter != null) {
            this.engineTransmitter.dispose();
        }
        if (this.oscQueryServer != null) {
            this.oscQueryServer.unbind();
        }
        if (this.zeroconf != null) {
            this.zeroconf.dispose();
        }
        this.disposeIO();
        this.stopReceiver(IOState.STOPPED);
        for (Receiver receiver : this.receivers) {
            receiver.stop();
        }
    }

    public static final void log(String message) {
        LX.log(OSC_LOG_PREFIX + message);
    }

    public static final void error(String message) {
        LX.error(OSC_LOG_PREFIX + message);
    }

    public static final void error(Throwable x, String message) {
        LX.error(x, OSC_LOG_PREFIX + message);
    }

    private class EngineListener
    implements LXOscListener {
        private EngineListener() {
        }

        @Override
        public void oscMessage(OscMessage message) {
            try {
                String[] parts;
                String raw = message.getAddressPattern().getValue();
                String trim = raw.trim();
                if (trim != raw) {
                    LXOscEngine.error("Trailing whitespace in OSC address pattern: \"" + raw + "\"");
                }
                if ((parts = trim.split("/"))[1].equals(((LXOscEngine)LXOscEngine.this).lx.engine.getPath())) {
                    ((LXOscEngine)LXOscEngine.this).lx.engine.handleOscMessage(message, parts, 2);
                } else if (parts[1].equals("adm")) {
                    ((LXOscEngine)LXOscEngine.this).lx.engine.audio.adm.handleAdmOscMessage(message, parts, 1);
                } else if (parts[1].equals("envelop")) {
                    ((LXOscEngine)LXOscEngine.this).lx.engine.audio.envelop.handleEnvelopOscMessage(message, parts, 1);
                } else if (parts[1].equals("reaper")) {
                    ((LXOscEngine)LXOscEngine.this).lx.engine.audio.reaper.handleReaperOscMessage(message, parts, 1);
                } else if (LXOscEngine.this.listeners.isEmpty()) {
                    throw new OscException();
                }
            }
            catch (Exception x) {
                LXOscEngine.error("Failed to handle OSC message: " + message.getAddressPattern().getValue());
            }
            for (LXOscListener listener : LXOscEngine.this.listeners) {
                try {
                    listener.oscMessage(message);
                }
                catch (Exception x) {
                    LXOscEngine.error(x, "Uncaught exception in custom listener: " + message.getAddressPattern().getValue());
                }
            }
        }
    }

    class EngineTransmitter
    extends Transmitter
    implements LXParameterListener {
        private final BooleanParameter active;
        private final EnumParameter<IOState> state;
        private LXOscConnection connection;
        private final OscMessage oscMessage;
        private final OscFloat oscFloat;
        private final OscInt oscInt;
        private final OscString oscString;

        EngineTransmitter(InetAddress address, int port, int bufferSize) throws SocketException {
            super(address, port, bufferSize);
            this.oscMessage = new OscMessage("");
            this.oscFloat = new OscFloat(0.0f);
            this.oscInt = new OscInt(0);
            this.oscString = new OscString("");
            this.active = LXOscEngine.this.transmitActive;
            this.state = LXOscEngine.this.transmitState;
            this.setActivity(LXOscEngine.this.transmitActivity);
            this.setLog(LXOscEngine.this.logOutput);
        }

        EngineTransmitter(InetAddress address, int port, int bufferSize, LXOscConnection.Output output) throws SocketException {
            super(address, port, bufferSize);
            this.oscMessage = new OscMessage("");
            this.oscFloat = new OscFloat(0.0f);
            this.oscInt = new OscInt(0);
            this.oscString = new OscString("");
            this.active = output.active;
            this.state = output.state;
            this.setActivity(output.activity);
            this.setLog(output.log);
        }

        void setConnection(LXOscConnection connection) {
            this.connection = connection;
            this.setLog(connection.log);
            this.setActivity(connection.activity);
        }

        private boolean isActive() {
            return this.active.isOn() && this.state.getEnum() == IOState.BOUND;
        }

        private boolean isAddressFiltered(String oscAddress) {
            String prefixFilter;
            String string = prefixFilter = this.connection != null ? this.connection.getFilter() : null;
            return prefixFilter != null && !OscMessage.hasPrefix(oscAddress, prefixFilter);
        }

        @Override
        public void onParameterChanged(LXParameter parameter) {
            if (!this.isActive()) {
                return;
            }
            String address = LXOscEngine.getOscAddress(parameter);
            if (address == null) {
                return;
            }
            if (this.isAddressFiltered(address)) {
                return;
            }
            this.oscMessage.clearArguments();
            this.oscMessage.setAddressPattern(address);
            if (parameter instanceof BooleanParameter) {
                BooleanParameter b = (BooleanParameter)parameter;
                this.oscInt.setValue(b.isOn() ? 1 : 0);
                this.oscMessage.add(this.oscInt);
            } else if (parameter instanceof StringParameter) {
                StringParameter string = (StringParameter)parameter;
                this.oscString.setValue(string.getString());
                this.oscMessage.add(this.oscString);
            } else if (parameter instanceof ColorParameter) {
                ColorParameter color = (ColorParameter)parameter;
                this.oscInt.setValue(color.getBaseColor());
                this.oscMessage.add(this.oscInt);
            } else if (parameter instanceof DiscreteParameter) {
                DiscreteParameter discrete = (DiscreteParameter)parameter;
                this.oscInt.setValue(discrete.getBaseValuei());
                this.oscMessage.add(this.oscInt);
            } else if (parameter instanceof LXNormalizedParameter) {
                LXNormalizedParameter normalizedParameter = (LXNormalizedParameter)parameter;
                if (normalizedParameter.getOscMode() == LXNormalizedParameter.OscMode.ABSOLUTE) {
                    this.oscFloat.setValue(normalizedParameter.getBaseValuef());
                } else {
                    this.oscFloat.setValue(normalizedParameter.getBaseNormalizedf());
                }
                this.oscMessage.add(this.oscFloat);
            } else {
                this.oscFloat.setValue(parameter.getBaseValuef());
                this.oscMessage.add(this.oscFloat);
            }
            this._sendMessage(this.oscMessage);
        }

        private void sendMessage(String address, int value) {
            if (this.isActive() && !this.isAddressFiltered(address)) {
                this.oscMessage.clearArguments();
                this.oscMessage.setAddressPattern(address);
                this.oscInt.setValue(value);
                this.oscMessage.add(this.oscInt);
                this._sendMessage(this.oscMessage);
            }
        }

        private void sendMessage(String address, float value) {
            if (this.isActive() && !this.isAddressFiltered(address)) {
                this.oscMessage.clearArguments();
                this.oscMessage.setAddressPattern(address);
                this.oscFloat.setValue(value);
                this.oscMessage.add(this.oscFloat);
                this._sendMessage(this.oscMessage);
            }
        }

        private void sendMessage(String address, String value) {
            if (this.isActive() && !this.isAddressFiltered(address)) {
                this.oscMessage.clearArguments();
                this.oscMessage.setAddressPattern(address);
                this.oscString.setValue(value);
                this.oscMessage.add(this.oscString);
                this._sendMessage(this.oscMessage);
            }
        }

        private void _sendMessage(OscMessage message) {
            try {
                this.send(this.oscMessage);
            }
            catch (IOException iox) {
                LXOscEngine.error(iox, "Failed to transmit message: " + message.getAddressPattern().toString());
            }
        }
    }

    public static interface IOListener {
        public void inputAdded(LXOscEngine var1, LXOscConnection.Input var2);

        public void inputRemoved(LXOscEngine var1, LXOscConnection.Input var2);

        public void outputAdded(LXOscEngine var1, LXOscConnection.Output var2);

        public void outputRemoved(LXOscEngine var1, LXOscConnection.Output var2);
    }

    public static enum IOState {
        STOPPED,
        BINDING,
        BOUND,
        UNKNOWN_HOST,
        SOCKET_ERROR;

    }

    public class Receiver {
        public final int port;
        private final DatagramSocket socket;
        public final SocketAddress address;
        private final DatagramPacket packet;
        private final byte[] buffer;
        private final ReceiverThread thread;
        private final AtomicBoolean hasMessages = new AtomicBoolean(false);
        private final List<OscMessage> threadSafeEventQueue = Collections.synchronizedList(new ArrayList());
        private final List<OscMessage> engineThreadEventQueue = new ArrayList<OscMessage>();
        private final List<LXOscListener> listeners = new ArrayList<LXOscListener>();
        private boolean inListener = false;
        private final List<LXOscListener> removeListeners = new ArrayList<LXOscListener>();
        private final List<LXOscListener> addListeners = new ArrayList<LXOscListener>();
        private BooleanParameter log;
        private TriggerParameter activity;
        private LXOscConnection connection;
        private boolean stopped = false;

        private Receiver(int port, InetAddress address, int bufferSize) throws SocketException {
            this(new DatagramSocket(port, address), port, bufferSize);
        }

        private Receiver(int port, int bufferSize) throws SocketException {
            this(new DatagramSocket(port), port, bufferSize);
        }

        private Receiver(DatagramSocket socket, int port, int bufferSize) throws SocketException {
            this.socket = socket;
            this.address = socket.getLocalSocketAddress();
            this.port = port;
            this.buffer = new byte[bufferSize];
            this.packet = new DatagramPacket(this.buffer, bufferSize);
            this.thread = new ReceiverThread();
            this.thread.start();
        }

        void setConnection(LXOscConnection connection) {
            this.connection = connection;
            this.setLog(connection.log);
            this.setActivity(connection.activity);
        }

        Receiver setLog(BooleanParameter log) {
            this.log = log;
            return this;
        }

        Receiver setActivity(TriggerParameter activity) {
            this.activity = activity;
            return this;
        }

        public Receiver addListener(LXOscListener listener) {
            Objects.requireNonNull("May not add null LXOscListener");
            if (this.listeners.contains(listener)) {
                throw new IllegalStateException("Cannot add duplicate LXOscEngine.Receiver.LXOscListener: " + String.valueOf(listener));
            }
            if (this.inListener) {
                this.addListeners.add(listener);
                return this;
            }
            this.listeners.add(listener);
            return this;
        }

        public Receiver removeListener(LXOscListener listener) {
            if (!this.listeners.contains(listener)) {
                throw new IllegalStateException("Cannot remove non-existent LXOscEngine.Receiver.LXOscListener: " + String.valueOf(listener));
            }
            if (this.inListener) {
                this.removeListeners.add(listener);
                return this;
            }
            this.listeners.remove(listener);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch() {
            if (this.hasMessages.compareAndSet(true, false)) {
                this.engineThreadEventQueue.clear();
                List<OscMessage> list = this.threadSafeEventQueue;
                synchronized (list) {
                    this.engineThreadEventQueue.addAll(this.threadSafeEventQueue);
                    this.threadSafeEventQueue.clear();
                }
                this.inListener = true;
                String prefixFilter = this.connection != null ? this.connection.getFilter() : null;
                for (OscMessage message : this.engineThreadEventQueue) {
                    if (prefixFilter != null && !message.hasPrefix(prefixFilter)) continue;
                    if (this.log != null && this.log.isOn()) {
                        LXOscEngine.log("[RX] [" + this.port + "] " + message.toString());
                    }
                    if (this.activity != null) {
                        this.activity.trigger();
                    }
                    for (LXOscListener listener2 : this.listeners) {
                        try {
                            listener2.oscMessage(message);
                        }
                        catch (Exception x) {
                            LXOscEngine.error(x, "Uncaught exception in OSC listener: " + message.getAddressPattern().getValue());
                        }
                    }
                }
                this.inListener = false;
                if (!this.removeListeners.isEmpty()) {
                    this.removeListeners.forEach(listener -> {
                        Receiver receiver = this.removeListener((LXOscListener)listener);
                    });
                    this.removeListeners.clear();
                }
                if (!this.addListeners.isEmpty()) {
                    this.addListeners.forEach(listener -> {
                        Receiver receiver = this.addListener((LXOscListener)listener);
                    });
                    this.addListeners.clear();
                }
            }
        }

        public void stop() {
            if (!this.stopped) {
                this.thread.interrupt();
                this.socket.close();
                this.listeners.clear();
                LXOscEngine.this.receivers.remove(this);
            }
            this.stopped = true;
        }

        class ReceiverThread
        extends Thread {
            ReceiverThread() {
            }

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    try {
                        Receiver.this.socket.receive(Receiver.this.packet);
                        try {
                            OscPacket oscPacket = OscPacket.parse(Receiver.this.packet);
                            if (oscPacket instanceof OscMessage) {
                                Receiver.this.threadSafeEventQueue.add((OscMessage)oscPacket);
                                Receiver.this.hasMessages.set(true);
                                continue;
                            }
                            if (!(oscPacket instanceof OscBundle)) continue;
                            for (OscMessage message : (OscBundle)oscPacket) {
                                Receiver.this.threadSafeEventQueue.add(message);
                            }
                            Receiver.this.hasMessages.set(true);
                        }
                        catch (OscException oscx) {
                            LXOscEngine.error(oscx, "Error handling OscPacket in receiver");
                        }
                    }
                    catch (IOException iox) {
                        if (this.isInterrupted()) continue;
                        LXOscEngine.error(iox, "Exception in OSC listener on port " + Receiver.this.port + ":" + iox.getLocalizedMessage());
                    }
                }
                Receiver.this.socket.close();
                LXOscEngine.log("Stopped OSC listener " + String.valueOf(Receiver.this.address));
            }
        }
    }

    public class Transmitter {
        private final byte[] bytes;
        private final ByteBuffer buffer;
        private final DatagramSocket socket;
        protected final DatagramPacket packet;
        private BooleanParameter log;
        private TriggerParameter activity;

        private Transmitter(InetAddress address, int port, int bufferSize) throws SocketException {
            this.bytes = new byte[bufferSize];
            this.buffer = ByteBuffer.wrap(this.bytes);
            this.packet = new DatagramPacket(this.bytes, this.bytes.length, address, port);
            this.socket = new DatagramSocket();
        }

        Transmitter setLog(BooleanParameter log) {
            this.log = log;
            return this;
        }

        Transmitter setActivity(TriggerParameter activity) {
            this.activity = activity;
            return this;
        }

        public void send(OscPacket packet) throws IOException {
            if (this.log != null && this.log.isOn()) {
                LXOscEngine.log("[TX] [" + this.packet.getPort() + "] " + packet.toString());
            }
            if (this.activity != null) {
                this.activity.trigger();
            }
            this.buffer.rewind();
            packet.serialize(this.buffer);
            this.packet.setLength(this.buffer.position());
            this.socket.send(this.packet);
        }

        public void setPort(int port) {
            this.packet.setPort(port);
        }

        public void setAddress(InetAddress host) {
            this.packet.setAddress(host);
        }

        public void dispose() {
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }

    private static class Zeroconf {
        private final String serviceName;
        private final JmDNS jmdns;
        private boolean registered = false;

        private static Zeroconf create(String serviceName) {
            try {
                return new Zeroconf(serviceName);
            }
            catch (Exception x) {
                LXOscEngine.error(x, "Failed to create Zeroconf instance");
                return null;
            }
        }

        private Zeroconf(String serviceName) throws IOException {
            this.serviceName = serviceName;
            this.jmdns = JmDNS.create((InetAddress)InetAddress.getLocalHost());
        }

        private void register(int port) {
            this.unregister();
            try {
                LXOscEngine.log("Registering zeroconf OSC services on port " + port);
                this.jmdns.registerService(ServiceInfo.create((String)"_osc._udp.local.", (String)(this.serviceName + ":" + port), (int)port, (String)""));
                this.registered = true;
                this.jmdns.registerService(ServiceInfo.create((String)"_oscjson._tcp.local.", (String)(this.serviceName + ":" + port), (int)port, (String)""));
            }
            catch (Exception x) {
                LXOscEngine.error(x, "Failed to register zeroconf services");
            }
        }

        private void unregister() {
            this.unregister(false);
        }

        private void unregister(boolean close) {
            boolean registered = this.registered;
            if (registered || close) {
                new Thread(() -> {
                    if (registered) {
                        this.jmdns.unregisterAllServices();
                    }
                    if (close) {
                        try {
                            this.jmdns.close();
                        }
                        catch (IOException iox) {
                            LXOscEngine.error(iox, "Exception closing JmDNS");
                        }
                    }
                }).start();
            }
            this.registered = false;
        }

        private void dispose() {
            this.unregister(true);
        }
    }
}

