/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import heronarts.lx.osc.OscArgument;
import heronarts.lx.osc.OscBlob;
import heronarts.lx.osc.OscChar;
import heronarts.lx.osc.OscDouble;
import heronarts.lx.osc.OscException;
import heronarts.lx.osc.OscFalse;
import heronarts.lx.osc.OscFloat;
import heronarts.lx.osc.OscInfinitum;
import heronarts.lx.osc.OscInt;
import heronarts.lx.osc.OscLong;
import heronarts.lx.osc.OscMalformedDataException;
import heronarts.lx.osc.OscMidi;
import heronarts.lx.osc.OscNil;
import heronarts.lx.osc.OscPacket;
import heronarts.lx.osc.OscRgba;
import heronarts.lx.osc.OscString;
import heronarts.lx.osc.OscSymbol;
import heronarts.lx.osc.OscTimeTag;
import heronarts.lx.osc.OscTrue;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OscMessage
extends OscPacket
implements Iterable<OscArgument> {
    private OscString addressPattern;
    private OscString typeTag;
    private boolean typeTagDirty = true;
    private InetAddress source;
    private final List<OscArgument> arguments = new ArrayList<OscArgument>();
    private int cursor = 0;
    public final long nanoTime = System.nanoTime();

    public OscMessage() {
    }

    public OscMessage(String addressPattern) {
        this.setAddressPattern(addressPattern);
    }

    public OscMessage clearArguments() {
        this.arguments.clear();
        this.typeTagDirty = true;
        return this;
    }

    public OscMessage add(OscArgument argument) {
        this.arguments.add(argument);
        this.typeTagDirty = true;
        return this;
    }

    public OscMessage add(int argument) {
        return this.add(new OscInt(argument));
    }

    public OscMessage add(String argument) {
        return this.add(new OscString(argument));
    }

    public OscMessage add(double argument) {
        return this.add(new OscDouble(argument));
    }

    public OscMessage add(float argument) {
        return this.add(new OscFloat(argument));
    }

    public int size() {
        return this.arguments.size();
    }

    public OscArgument get() {
        return this.arguments.get(this.cursor++);
    }

    public OscArgument get(int index) {
        return this.arguments.get(index);
    }

    public int getInt() {
        return this.get().toInt();
    }

    public int getInt(int index) {
        return this.get(index).toInt();
    }

    public boolean getBoolean() {
        return this.get().toBoolean();
    }

    public boolean getBoolean(int index) {
        return this.get(index).toBoolean();
    }

    public float getFloat() {
        return this.get().toFloat();
    }

    public float getFloat(int index) {
        return this.get(index).toFloat();
    }

    public double getDouble() {
        return this.get().toDouble();
    }

    public double getDouble(int index) {
        return this.get(index).toDouble();
    }

    public String getString() {
        return this.get().toString();
    }

    public String getString(int index) {
        return this.get(index).toString();
    }

    public OscBlob getBlob() {
        return (OscBlob)this.get();
    }

    public OscBlob getBlob(int index) {
        return (OscBlob)this.get(index);
    }

    public OscMessage resetCursor() {
        this.cursor = 0;
        return this;
    }

    public OscMessage setAddressPattern(String addressPattern) {
        this.addressPattern = new OscString(addressPattern);
        return this;
    }

    public OscMessage setAddressPattern(OscString addressPattern) {
        this.addressPattern = addressPattern;
        return this;
    }

    OscMessage setSource(InetAddress address) {
        this.source = address;
        return this;
    }

    public InetAddress getSource() {
        return this.source;
    }

    public OscString getAddressPattern() {
        return this.addressPattern;
    }

    private void rebuildTypeTag() {
        char[] typeTag = new char[this.arguments.size() + 1];
        int i = 0;
        typeTag[i++] = 44;
        for (OscArgument argument : this.arguments) {
            typeTag[i++] = argument.getTypeTag();
        }
        this.typeTag = new OscString(typeTag);
        this.typeTagDirty = false;
    }

    public OscString getTypeTag() {
        if (this.typeTagDirty) {
            this.rebuildTypeTag();
        }
        return this.typeTag;
    }

    public boolean matches(String pattern) {
        return this.addressPattern.getValue().equals(pattern);
    }

    public boolean hasPrefix(String pattern) {
        return OscMessage.hasPrefix(this.addressPattern.getValue(), pattern);
    }

    public static boolean hasPrefix(String address, String pattern) {
        return address.startsWith(pattern) && (address.length() == pattern.length() || pattern.charAt(pattern.length() - 1) == '/' || address.charAt(pattern.length()) == '/');
    }

    public static OscMessage parse(InetAddress source, byte[] data, int offset, int len) throws OscException {
        OscMessage message = new OscMessage();
        message.setSource(source);
        OscString addressPattern = OscString.parse(data, offset, len);
        message.setAddressPattern(addressPattern);
        if ((offset += addressPattern.getByteLength()) < len) {
            OscString typeTag = OscString.parse(data, offset, len);
            offset += typeTag.getByteLength();
            ByteBuffer buffer = ByteBuffer.wrap(data);
            String typeTagValue = typeTag.getValue();
            int i = 1;
            while (i < typeTagValue.length()) {
                char tag = typeTagValue.charAt(i);
                OscArgument argument = null;
                switch (tag) {
                    case 'i': {
                        argument = new OscInt(buffer.getInt(offset));
                        break;
                    }
                    case 'f': {
                        argument = new OscFloat(buffer.getFloat(offset));
                        break;
                    }
                    case 's': {
                        argument = OscString.parse(data, offset, len);
                        break;
                    }
                    case 'b': {
                        int blobLength = buffer.getInt(offset);
                        byte[] blobData = new byte[blobLength];
                        System.arraycopy(buffer, offset, blobData, 0, blobLength);
                        argument = new OscBlob(blobData);
                        break;
                    }
                    case 'h': {
                        argument = new OscLong(buffer.getLong(offset));
                        break;
                    }
                    case 't': {
                        argument = new OscTimeTag(buffer.getLong(offset));
                        break;
                    }
                    case 'd': {
                        argument = new OscDouble(buffer.getDouble(offset));
                        break;
                    }
                    case 'S': {
                        argument = OscSymbol.parse(data, offset, len);
                        break;
                    }
                    case 'c': {
                        argument = new OscChar((char)buffer.getInt(offset));
                        break;
                    }
                    case 'r': {
                        argument = new OscRgba(buffer.getInt(offset));
                        break;
                    }
                    case 'm': {
                        argument = new OscMidi(buffer.getInt(offset));
                        break;
                    }
                    case 'T': {
                        argument = new OscTrue();
                        break;
                    }
                    case 'F': {
                        argument = new OscFalse();
                        break;
                    }
                    case 'N': {
                        argument = new OscNil();
                        break;
                    }
                    case 'I': {
                        argument = new OscInfinitum();
                        break;
                    }
                    default: {
                        throw new OscMalformedDataException("Unrecognized type tag: " + tag, data, offset, len);
                    }
                }
                offset += argument.getByteLength();
                message.add(argument);
                ++i;
            }
        }
        return message;
    }

    @Override
    public Iterator<OscArgument> iterator() {
        return this.arguments.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.addressPattern.toString());
        if (this.typeTag != null) {
            sb.append(this.typeTag.toString());
        }
        boolean first = true;
        for (OscArgument argument : this) {
            if (first) {
                sb.append(' ');
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(argument.toString());
        }
        return sb.toString();
    }

    @Override
    void serialize(ByteBuffer buffer) {
        this.addressPattern.serialize(buffer);
        this.getTypeTag().serialize(buffer);
        for (OscArgument argument : this.arguments) {
            argument.serialize(buffer);
        }
    }
}

