/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.osc;

import heronarts.lx.osc.OscBundle;
import heronarts.lx.osc.OscEmptyPacketException;
import heronarts.lx.osc.OscException;
import heronarts.lx.osc.OscMalformedDataException;
import heronarts.lx.osc.OscMessage;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public abstract class OscPacket {
    public static OscPacket parse(InetAddress source, byte[] data, int offset, int len) throws OscException {
        if (data == null) {
            throw new IllegalArgumentException("OscPacket cannot parse null data array");
        }
        if (len <= 0) {
            throw new OscEmptyPacketException();
        }
        if (data[offset] == 35) {
            return OscBundle.parse(source, data, offset, len);
        }
        if (data[offset] == 47) {
            return OscMessage.parse(source, data, offset, len);
        }
        throw new OscMalformedDataException("Osc Packet does not start with # or / --- " + new String(data, 0, len < 10 ? len : 10), data, offset, len);
    }

    public static OscPacket parse(DatagramPacket datagram) throws OscException {
        return OscPacket.parse(datagram.getAddress(), datagram.getData(), datagram.getOffset(), datagram.getLength());
    }

    abstract void serialize(ByteBuffer var1);
}

