/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXDatagram;

public class DDPDatagram
extends LXDatagram {
    public static final int MAX_DATA_LENGTH = 65535;
    public static final int DEFAULT_PORT = 4048;
    private static final int HEADER_LENGTH = 10;
    private static final int FLAGS_INDEX = 0;
    private static final int OFFSET_DATA_OFFSET = 4;

    public DDPDatagram(LX lx, LXModel model) {
        this(lx, model.toIndexBuffer());
    }

    public DDPDatagram(LX lx, int[] indexBuffer) {
        this(lx, indexBuffer, 0);
    }

    public DDPDatagram(LX lx, int[] indexBuffer, int dataOffset) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, dataOffset);
    }

    public DDPDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, int dataOffset) {
        this(lx, new IndexBuffer(indexBuffer, byteOrder), dataOffset);
    }

    public DDPDatagram(LX lx, IndexBuffer indexBuffer, int dataOffset) {
        super(lx, indexBuffer, 10 + indexBuffer.numChannels);
        this.setPort(4048);
        this.validateBufferSize();
        this.buffer[0] = 65;
        this.buffer[1] = 0;
        this.buffer[2] = 0;
        this.buffer[3] = 1;
        this.setDataOffset(dataOffset);
        int dataLen = indexBuffer.numChannels;
        this.buffer[8] = (byte)(0xFF & dataLen >> 8);
        this.buffer[9] = (byte)(0xFF & dataLen);
    }

    public DDPDatagram setPushFlag(boolean push) {
        this.buffer[0] = push ? (byte)(this.buffer[0] | 1) : (byte)(this.buffer[0] & 0xFFFFFFFE);
        return this;
    }

    public DDPDatagram setDataOffset(int offset) {
        this.buffer[4] = (byte)(0xFF & offset >>> 24);
        this.buffer[5] = (byte)(0xFF & offset >>> 16);
        this.buffer[6] = (byte)(0xFF & offset >>> 8);
        this.buffer[7] = (byte)(0xFF & offset);
        return this;
    }

    @Override
    protected int getDataBufferOffset() {
        return 10;
    }
}

