/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.DDPDatagram;
import heronarts.lx.output.LXDatagram;
import heronarts.lx.output.LXOutput;
import heronarts.lx.output.LXOutputGroup;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DDPOutputGroup
extends LXOutputGroup
implements LXOutput.InetOutput {
    private final List<DDPDatagram> datagrams = new ArrayList<DDPDatagram>();
    private InetAddress address = null;
    private int port = -1;
    public static final int DEFAULT_CHUNK_SIZE = 400;

    public DDPOutputGroup(LX lx, LXModel model) {
        this(lx, model.toIndexBuffer());
    }

    public DDPOutputGroup(LX lx, LXModel model, int chunkSize) {
        this(lx, model.toIndexBuffer(), chunkSize);
    }

    public DDPOutputGroup(LX lx, int[] indexBuffer) {
        this(lx, indexBuffer, 400);
    }

    public DDPOutputGroup(LX lx, int[] indexBuffer, int chunkSize) {
        super(lx);
        int total = indexBuffer.length;
        int start = 0;
        while (start < total) {
            int end = Math.min(start + chunkSize, total);
            int[] chunk = Arrays.copyOfRange(indexBuffer, start, end);
            DDPDatagram datagram = new DDPDatagram(lx, chunk);
            datagram.setDataOffset(start);
            datagram.setPushFlag(end == total);
            this.datagrams.add(datagram);
            this.addChild(datagram);
            start = end;
        }
    }

    public DDPOutputGroup setPushAll(boolean pushAll) {
        int i = 0;
        int len = this.datagrams.size();
        for (LXDatagram lXDatagram : this.datagrams) {
            ((DDPDatagram)lXDatagram).setPushFlag(pushAll | i == len - 1);
            ++i;
        }
        return this;
    }

    @Override
    public LXOutput.InetOutput setAddress(InetAddress address) {
        this.address = address;
        for (DDPDatagram datagram : this.datagrams) {
            datagram.setAddress(address);
        }
        return this;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public LXOutput.InetOutput setPort(int port) {
        this.port = port;
        for (DDPDatagram datagram : this.datagrams) {
            datagram.setPort(port);
        }
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

