/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.parameter.FixedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;
import java.util.List;

public class IndexBuffer {
    public static final int EMPTY_PIXEL = -1;
    public final Segment[] segments;
    public final int numChannels;

    public IndexBuffer(int[] indices) {
        this(new Segment(indices));
    }

    public IndexBuffer(int[] indices, LXBufferOutput.ByteOrder byteOrder) {
        this(new Segment(indices, byteOrder));
    }

    public IndexBuffer(int[] indices, LXBufferOutput.ByteOrder byteOrder, int channel) {
        this(new Segment(indices, byteOrder, channel));
    }

    public IndexBuffer(int[] indices, LXBufferOutput.ByteOrder byteOrder, int channel, LXParameter brightness) {
        this(new Segment(indices, byteOrder, channel, brightness));
    }

    public IndexBuffer(List<Segment> segments) {
        this(segments.toArray(new Segment[0]));
    }

    public IndexBuffer(Segment ... segments) {
        this.segments = segments;
        int numChannels = 0;
        Segment[] segmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment segment = segmentArray[n2];
            numChannels = LXUtils.max(numChannels, segment.getRequiredChannels());
            ++n2;
        }
        this.numChannels = numChannels;
    }

    public static class Segment {
        public final byte[] staticBytes;
        public final int[] indices;
        public final LXBufferOutput.ByteEncoder byteEncoder;
        public final int startChannel;
        public final int outputStride;
        public final LXParameter brightness;

        public Segment(int[] indices) {
            this(indices, LXBufferOutput.ByteOrder.RGB);
        }

        public Segment(int[] indices, LXBufferOutput.ByteEncoder byteEncoder) {
            this(indices, byteEncoder, 0);
        }

        public Segment(int[] indices, LXBufferOutput.ByteEncoder byteEncoder, int channel) {
            this(indices, byteEncoder, channel, new FixedParameter(1.0));
        }

        public Segment(int[] indices, LXBufferOutput.ByteEncoder byteEncoder, int channel, LXParameter brightness) {
            this(indices, byteEncoder, channel, byteEncoder.getNumBytes(), brightness);
        }

        public Segment(int[] indices, LXBufferOutput.ByteEncoder byteEncoder, int channel, int outputStride, LXParameter brightness) {
            this.indices = indices;
            this.byteEncoder = byteEncoder;
            this.outputStride = outputStride;
            this.startChannel = channel;
            this.brightness = brightness;
            this.staticBytes = null;
        }

        public Segment(byte[] staticBytes, int channel) {
            this.staticBytes = staticBytes;
            this.startChannel = channel;
            this.indices = null;
            this.outputStride = 1;
            this.byteEncoder = null;
            this.brightness = null;
        }

        public int getRequiredChannels() {
            int numChannels = 0;
            if (this.byteEncoder != null) {
                numChannels = this.outputStride * this.indices.length;
                if (this.indices.length > 0) {
                    numChannels -= this.outputStride - this.byteEncoder.getNumBytes();
                }
            } else {
                numChannels = this.staticBytes.length;
            }
            return this.startChannel + numChannels;
        }
    }
}

