/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.model.LXModel;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXDatagram;

public class KinetDatagram
extends LXDatagram {
    private static final int DMXOUT_HEADER_LENGTH = 21;
    private static final int PORTOUT_HEADER_LENGTH = 24;
    private static final int DATA_LENGTH = 512;
    public static final int MAX_DATA_LENGTH = 512;
    public static final int MAX_KINET_PORT = 255;
    private static final int PORTOUT_PACKET_LENGTH = 536;
    private static final int DMXOUT_PACKET_LENGTH = 533;
    public static final int KINET_PORT = 6038;
    private final Version version;

    public KinetDatagram(LX lx, LXModel model, int kinetPort) {
        this(lx, model, kinetPort, Version.PORTOUT);
    }

    public KinetDatagram(LX lx, LXModel model, int kinetPort, Version version) {
        this(lx, model.toIndexBuffer(), LXBufferOutput.ByteOrder.RGB, kinetPort, version);
    }

    public KinetDatagram(LX lx, int[] indexBuffer, int kinetPort) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB, kinetPort, Version.PORTOUT);
    }

    public KinetDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, int kinetPort) {
        this(lx, indexBuffer, byteOrder, kinetPort, Version.PORTOUT);
    }

    public KinetDatagram(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder, int kinetPort, Version version) {
        this(lx, new IndexBuffer(indexBuffer, byteOrder), kinetPort, version);
    }

    public KinetDatagram(LX lx, IndexBuffer indexBuffer, int kinetPort) {
        this(lx, indexBuffer, kinetPort, Version.PORTOUT);
    }

    public KinetDatagram(LX lx, IndexBuffer indexBuffer, int kinetPort, Version version) {
        super(lx, indexBuffer, version.packetLength);
        this.setPort(6038);
        this.version = version;
        this.validateBufferSize();
        this.buffer[0] = 4;
        this.buffer[1] = 1;
        this.buffer[2] = -36;
        this.buffer[3] = 74;
        switch (this.version) {
            case PORTOUT: {
                this.buffer[4] = 1;
                this.buffer[5] = 0;
                this.buffer[6] = 8;
                this.buffer[7] = 1;
                this.buffer[8] = 0;
                this.buffer[9] = 0;
                this.buffer[10] = 0;
                this.buffer[11] = 0;
                this.buffer[12] = -1;
                this.buffer[13] = -1;
                this.buffer[14] = -1;
                this.buffer[15] = -1;
                this.buffer[16] = (byte)(0xFF & kinetPort);
                this.buffer[17] = 0;
                this.buffer[18] = 0;
                this.buffer[19] = 0;
                this.buffer[20] = 0;
                this.buffer[21] = 2;
                this.buffer[22] = 0;
                this.buffer[23] = 0;
                break;
            }
            case DMXOUT: {
                this.buffer[4] = 1;
                this.buffer[5] = 0;
                this.buffer[6] = 1;
                this.buffer[7] = 1;
                this.buffer[8] = 0;
                this.buffer[9] = 0;
                this.buffer[10] = 0;
                this.buffer[11] = 0;
                this.buffer[12] = 0;
                this.buffer[13] = 64;
                this.buffer[14] = 0;
                this.buffer[15] = 0;
                this.buffer[16] = (byte)(0xFF & kinetPort);
                this.buffer[17] = 0;
                this.buffer[18] = 0;
                this.buffer[19] = 0;
                this.buffer[20] = 0;
            }
        }
    }

    public KinetDatagram setKinetPort(byte kinetPort) {
        this.buffer[16] = kinetPort;
        return this;
    }

    @Override
    protected int getDataBufferOffset() {
        return this.version.headerLength;
    }

    public static enum Version {
        DMXOUT(21, 533),
        PORTOUT(24, 536);

        public final int headerLength;
        public final int packetLength;

        private Version(int headerLength, int packetLength) {
            this.headerLength = headerLength;
            this.packetLength = packetLength;
        }
    }
}

