/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXOutput;

public abstract class LXBufferOutput
extends LXOutput {
    protected final IndexBuffer indexBuffer;

    protected LXBufferOutput(LX lx, IndexBuffer indexBuffer) {
        super(lx);
        this.indexBuffer = indexBuffer;
    }

    protected abstract byte[] getDataBuffer();

    protected abstract int getDataBufferOffset();

    protected LXBufferOutput updateDataBuffer(int[] colors, LXOutput.GammaTable glut, double brightness) {
        byte[] buffer = this.getDataBuffer();
        IndexBuffer.Segment[] segmentArray = this.indexBuffer.segments;
        int n = this.indexBuffer.segments.length;
        int n2 = 0;
        while (n2 < n) {
            IndexBuffer.Segment segment = segmentArray[n2];
            int offset = this.getDataBufferOffset() + segment.startChannel;
            if (segment.staticBytes != null) {
                System.arraycopy(segment.staticBytes, 0, buffer, offset, segment.staticBytes.length);
            } else if (segment.indices != null) {
                int glutIndex = (int)Math.round(255.0 * brightness * segment.brightness.getValue());
                LXOutput.GammaTable.Curve gamma = glut.level[glutIndex];
                ByteEncoder byteEncoder = segment.byteEncoder;
                int numBytes = byteEncoder.getNumBytes();
                int stride = segment.outputStride;
                if (byteEncoder instanceof ByteOrder) {
                    ByteOrder byteOrder = (ByteOrder)byteEncoder;
                    int[] byteOffset = byteOrder.getByteOffset();
                    if (byteOrder.hasWhite) {
                        if (numBytes == 1) {
                            i = 0;
                            while (i < segment.indices.length) {
                                index = segment.indices[i];
                                color = index >= 0 ? colors[index] : 0;
                                r = color >> 16 & 0xFF;
                                g = color >> 8 & 0xFF;
                                b = color & 0xFF;
                                w = (r + b + g) / 3;
                                buffer[offset] = gamma.white[w];
                                offset += stride;
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < segment.indices.length) {
                                index = segment.indices[i];
                                color = index >= 0 ? colors[index] : 0;
                                r = color >> 16 & 0xFF;
                                g = color >> 8 & 0xFF;
                                b = color & 0xFF;
                                w = r < g ? (r < b ? r : b) : (g < b ? g : b);
                                buffer[offset + byteOffset[0]] = gamma.red[r -= w];
                                buffer[offset + byteOffset[1]] = gamma.green[g -= w];
                                buffer[offset + byteOffset[2]] = gamma.blue[b -= w];
                                buffer[offset + byteOffset[3]] = gamma.white[w];
                                offset += stride;
                                ++i;
                            }
                        }
                    } else {
                        i = 0;
                        while (i < segment.indices.length) {
                            index = segment.indices[i];
                            color = index >= 0 ? colors[index] : 0;
                            buffer[offset + byteOffset[0]] = gamma.red[color >> 16 & 0xFF];
                            buffer[offset + byteOffset[1]] = gamma.green[color >> 8 & 0xFF];
                            buffer[offset + byteOffset[2]] = gamma.blue[color & 0xFF];
                            offset += stride;
                            ++i;
                        }
                    }
                } else {
                    int i = 0;
                    while (i < segment.indices.length) {
                        int index = segment.indices[i];
                        int color = index >= 0 ? colors[index] : 0;
                        byteEncoder.writeBytes(color, gamma, buffer, offset);
                        offset += stride;
                        ++i;
                    }
                }
            }
            ++n2;
        }
        return this;
    }

    public static interface ByteEncoder {
        public int getNumBytes();

        public void writeBytes(int var1, LXOutput.GammaTable.Curve var2, byte[] var3, int var4);
    }

    public static final class ByteOrder
    extends Enum<ByteOrder>
    implements ByteEncoder {
        public static final /* enum */ ByteOrder RGB;
        public static final /* enum */ ByteOrder RBG;
        public static final /* enum */ ByteOrder GRB;
        public static final /* enum */ ByteOrder GBR;
        public static final /* enum */ ByteOrder BRG;
        public static final /* enum */ ByteOrder BGR;
        public static final /* enum */ ByteOrder RGBW;
        public static final /* enum */ ByteOrder RBGW;
        public static final /* enum */ ByteOrder GRBW;
        public static final /* enum */ ByteOrder GBRW;
        public static final /* enum */ ByteOrder BRGW;
        public static final /* enum */ ByteOrder BGRW;
        public static final /* enum */ ByteOrder WRGB;
        public static final /* enum */ ByteOrder WRBG;
        public static final /* enum */ ByteOrder WGRB;
        public static final /* enum */ ByteOrder WGBR;
        public static final /* enum */ ByteOrder WBRG;
        public static final /* enum */ ByteOrder WBGR;
        public static final /* enum */ ByteOrder W;
        private final int[] byteOffset;
        public final boolean hasWhite;
        private static final /* synthetic */ ByteOrder[] ENUM$VALUES;

        static {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            RGB = new ByteOrder(nArray);
            int[] nArray2 = new int[3];
            nArray2[1] = 2;
            nArray2[2] = 1;
            RBG = new ByteOrder(nArray2);
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[2] = 2;
            GRB = new ByteOrder(nArray3);
            int[] nArray4 = new int[3];
            nArray4[0] = 2;
            nArray4[2] = 1;
            GBR = new ByteOrder(nArray4);
            int[] nArray5 = new int[3];
            nArray5[0] = 1;
            nArray5[1] = 2;
            BRG = new ByteOrder(nArray5);
            int[] nArray6 = new int[3];
            nArray6[0] = 2;
            nArray6[1] = 1;
            BGR = new ByteOrder(nArray6);
            int[] nArray7 = new int[4];
            nArray7[1] = 1;
            nArray7[2] = 2;
            nArray7[3] = 3;
            RGBW = new ByteOrder(nArray7, true);
            int[] nArray8 = new int[4];
            nArray8[1] = 2;
            nArray8[2] = 1;
            nArray8[3] = 3;
            RBGW = new ByteOrder(nArray8, true);
            int[] nArray9 = new int[4];
            nArray9[0] = 1;
            nArray9[2] = 2;
            nArray9[3] = 3;
            GRBW = new ByteOrder(nArray9, true);
            int[] nArray10 = new int[4];
            nArray10[0] = 2;
            nArray10[2] = 1;
            nArray10[3] = 3;
            GBRW = new ByteOrder(nArray10, true);
            int[] nArray11 = new int[4];
            nArray11[0] = 1;
            nArray11[1] = 2;
            nArray11[3] = 3;
            BRGW = new ByteOrder(nArray11, true);
            int[] nArray12 = new int[4];
            nArray12[0] = 2;
            nArray12[1] = 1;
            nArray12[3] = 3;
            BGRW = new ByteOrder(nArray12, true);
            int[] nArray13 = new int[4];
            nArray13[0] = 1;
            nArray13[1] = 2;
            nArray13[2] = 3;
            WRGB = new ByteOrder(nArray13, true);
            int[] nArray14 = new int[4];
            nArray14[0] = 1;
            nArray14[1] = 3;
            nArray14[2] = 2;
            WRBG = new ByteOrder(nArray14, true);
            int[] nArray15 = new int[4];
            nArray15[0] = 2;
            nArray15[1] = 1;
            nArray15[2] = 3;
            WGRB = new ByteOrder(nArray15, true);
            int[] nArray16 = new int[4];
            nArray16[0] = 3;
            nArray16[1] = 1;
            nArray16[2] = 2;
            WGBR = new ByteOrder(nArray16, true);
            int[] nArray17 = new int[4];
            nArray17[0] = 2;
            nArray17[1] = 3;
            nArray17[2] = 1;
            WBRG = new ByteOrder(nArray17, true);
            int[] nArray18 = new int[4];
            nArray18[0] = 3;
            nArray18[1] = 2;
            nArray18[2] = 1;
            WBGR = new ByteOrder(nArray18, true);
            W = new ByteOrder(new int[1], true);
            ENUM$VALUES = new ByteOrder[]{RGB, RBG, GRB, GBR, BRG, BGR, RGBW, RBGW, GRBW, GBRW, BRGW, BGRW, WRGB, WRBG, WGRB, WGBR, WBRG, WBGR, W};
        }

        private ByteOrder(int[] byteOffset) {
            this(byteOffset, false);
        }

        private ByteOrder(int[] byteOffset, boolean hasWhite) {
            this.byteOffset = byteOffset;
            this.hasWhite = hasWhite;
        }

        @Override
        public int getNumBytes() {
            return this.byteOffset.length;
        }

        public int[] getByteOffset() {
            return this.byteOffset;
        }

        @Override
        public void writeBytes(int color, LXOutput.GammaTable.Curve gamma, byte[] output, int offset) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            if (this.hasWhite) {
                if (this.byteOffset.length == 1) {
                    output[offset] = gamma.white[(r + b + g) / 3];
                } else {
                    int w = r < g ? (r < b ? r : b) : (g < b ? g : b);
                    output[offset + this.byteOffset[0]] = gamma.red[r - w];
                    output[offset + this.byteOffset[1]] = gamma.green[g - w];
                    output[offset + this.byteOffset[2]] = gamma.blue[b - w];
                    output[offset + this.byteOffset[3]] = gamma.white[w];
                }
            } else {
                output[offset + this.byteOffset[0]] = gamma.red[r];
                output[offset + this.byteOffset[1]] = gamma.green[g];
                output[offset + this.byteOffset[2]] = gamma.blue[b];
            }
        }

        public static ByteOrder[] values() {
            ByteOrder[] byteOrderArray = ENUM$VALUES;
            int n = byteOrderArray.length;
            ByteOrder[] byteOrderArray2 = new ByteOrder[n];
            System.arraycopy(ENUM$VALUES, 0, byteOrderArray2, 0, n);
            return byteOrderArray2;
        }

        public static ByteOrder valueOf(String string) {
            return Enum.valueOf(ByteOrder.class, string);
        }
    }
}

