/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXOutput;
import heronarts.lx.parameter.BooleanParameter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;

public abstract class LXDatagram
extends LXBufferOutput
implements LXOutput.InetOutput {
    private static DatagramSocket defaultSocket = null;
    private static final Map<String, ErrorState> _datagramErrorState = new HashMap<String, ErrorState>();
    protected final byte[] buffer;
    ErrorState errorState = null;
    final DatagramPacket packet;
    private DatagramSocket socket;
    public final BooleanParameter error = new BooleanParameter("Error", false).setDescription("Whether there have been errors sending to this datagram address");
    private static long slowPacketInitMs = -1L;
    private static int slowPacketCount = 0;
    private static boolean slowPacketLogged = false;

    private static DatagramSocket getDefaultSocket() throws SocketException {
        if (defaultSocket == null) {
            defaultSocket = new DatagramSocket();
        }
        return defaultSocket;
    }

    private static ErrorState getDatagramErrorState(LXDatagram datagram) {
        String destination = String.valueOf(datagram.getAddress()) + ":" + datagram.getPort();
        ErrorState datagramErrorState = _datagramErrorState.get(destination);
        if (datagramErrorState == null) {
            datagramErrorState = new ErrorState(destination);
            _datagramErrorState.put(destination, datagramErrorState);
        }
        return datagramErrorState;
    }

    protected LXDatagram(LX lx, IndexBuffer indexBuffer, int datagramSize) {
        super(lx, indexBuffer);
        this.buffer = new byte[datagramSize];
        int i = 0;
        while (i < datagramSize) {
            this.buffer[i] = 0;
            ++i;
        }
        this.packet = new DatagramPacket(this.buffer, datagramSize);
    }

    protected void validateBufferSize() {
        int dataSize = this.buffer.length - this.getDataBufferOffset();
        if (dataSize < this.indexBuffer.numChannels) {
            String cls = this.getClass().getSimpleName();
            throw new BufferException(cls + " dataSize " + dataSize + " is insufficient for indexBuffer with " + this.indexBuffer.numChannels + " channels");
        }
    }

    public LXDatagram setSocket(DatagramSocket socket) {
        this.socket = socket;
        return this;
    }

    protected ErrorState getErrorState() {
        if (this.errorState != null) {
            return this.errorState;
        }
        this.errorState = LXDatagram.getDatagramErrorState(this);
        return this.errorState;
    }

    @Override
    public LXDatagram setAddress(InetAddress address) {
        this.errorState = null;
        this.packet.setAddress(address);
        return this;
    }

    @Override
    public InetAddress getAddress() {
        return this.packet.getAddress();
    }

    @Override
    public LXDatagram setPort(int port) {
        this.errorState = null;
        this.packet.setPort(port);
        return this;
    }

    @Override
    public int getPort() {
        return this.packet.getPort();
    }

    @Override
    public byte[] getDataBuffer() {
        return this.buffer;
    }

    protected void updateSequenceNumber() {
    }

    @Override
    protected void onSend(int[] colors, LXOutput.GammaTable glut, double brightness) {
        block7: {
            ErrorState datagramErrorState = this.getErrorState();
            if (datagramErrorState.sendAfter >= this.lx.engine.nowMillis) {
                this.error.setValue(true);
                return;
            }
            this.updateDataBuffer(colors, glut, brightness);
            this.updateSequenceNumber();
            try {
                long afterSend;
                DatagramSocket socket = this.socket != null ? this.socket : LXDatagram.getDefaultSocket();
                long latencyCheck = System.currentTimeMillis();
                if (slowPacketInitMs < 0L) {
                    slowPacketInitMs = latencyCheck;
                }
                socket.send(this.packet);
                if (!slowPacketLogged && (afterSend = System.currentTimeMillis()) - latencyCheck > 1L && ++slowPacketCount > 10 && afterSend - slowPacketInitMs > 5000L) {
                    LX.error("Calls to DatagramSocket.send() appear to be unexpectedly blocking, you may be sending to an unresolvable address or network queues may be saturated. If you are on Linux/Raspberry-Pi, consult the following URL for guidance on relevant kernel parameters: https://github.com/heronarts/LXStudio/wiki/Raspberry-Pi");
                    slowPacketLogged = true;
                }
                if (datagramErrorState.failureCount > 0) {
                    LXOutput.log("Recovered connectivity to " + datagramErrorState.destination);
                }
                datagramErrorState.failureCount = 0;
                datagramErrorState.sendAfter = 0L;
                this.error.setValue(false);
            }
            catch (IOException iox) {
                this.error.setValue(true);
                if (datagramErrorState.failureCount == 0) {
                    LXOutput.error("IOException sending to " + datagramErrorState.destination + " (" + iox.getLocalizedMessage() + "), will initiate backoff after 3 consecutive failures");
                }
                ++datagramErrorState.failureCount;
                if (datagramErrorState.failureCount < 3) break block7;
                int pow = Math.min(5, datagramErrorState.failureCount - 3);
                long waitFor = (long)(50.0 * Math.pow(2.0, pow));
                LXOutput.error("Retrying " + datagramErrorState.destination + " in " + waitFor + "ms (" + datagramErrorState.failureCount + " consecutive failures)");
                datagramErrorState.sendAfter = this.lx.engine.nowMillis + waitFor;
            }
        }
    }

    public static class BufferException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public BufferException(String message) {
            super(message);
        }
    }

    protected static class ErrorState {
        final String destination;
        int failureCount = 0;
        long sendAfter = 0L;

        private ErrorState(String destination) {
            this.destination = destination;
        }
    }
}

