/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.output;

import heronarts.lx.LX;
import heronarts.lx.output.IndexBuffer;
import heronarts.lx.output.LXBufferOutput;
import heronarts.lx.output.LXOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public abstract class LXSocket
extends LXBufferOutput
implements LXOutput.InetOutput {
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 100;
    private InetAddress address = null;
    private int port = -1;
    private int connectTimeoutMs = 100;
    protected Socket socket;
    protected OutputStream output;
    private int failureCount = 0;
    private long sendAfter = 0L;

    protected LXSocket(LX lx, int[] indexBuffer) {
        this(lx, indexBuffer, LXBufferOutput.ByteOrder.RGB);
    }

    protected LXSocket(LX lx, int[] indexBuffer, LXBufferOutput.ByteOrder byteOrder) {
        this(lx, new IndexBuffer(indexBuffer, byteOrder));
    }

    protected LXSocket(LX lx, IndexBuffer indexBuffer) {
        super(lx, indexBuffer);
    }

    public LXSocket setConnectTimeout(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
        return this;
    }

    @Override
    public LXSocket setAddress(InetAddress address) {
        if (this.address != address) {
            this.disconnect(null);
            this.failureCount = 0;
            this.sendAfter = 0L;
            this.address = address;
        }
        return this;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public LXSocket setPort(int port) {
        if (this.port != port) {
            this.disconnect(null);
            this.port = port;
            this.failureCount = 0;
            this.sendAfter = 0L;
        }
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    private void connect() {
        if (this.socket == null && this.address != null && this.port != -1) {
            if (this.sendAfter >= this.lx.engine.nowMillis) {
                return;
            }
            InetSocketAddress inetAddress = new InetSocketAddress(this.address, this.port);
            try {
                this.socket = new Socket();
                this.socket.connect(inetAddress, this.connectTimeoutMs);
                this.socket.setTcpNoDelay(true);
                this.output = this.socket.getOutputStream();
                if (this.failureCount > 0) {
                    LXOutput.log(this.getClass().getSimpleName() + " recovered connectivity to " + String.valueOf(inetAddress));
                }
                this.failureCount = 0;
                this.sendAfter = 0L;
                this.didConnect();
            }
            catch (IOException iox) {
                if (this.failureCount == 0) {
                    LXOutput.error(this.getClass().getSimpleName() + " failed connecting to " + String.valueOf(inetAddress) + ", will initiate backoff after 3 consecutive failures: " + iox.getLocalizedMessage());
                }
                ++this.failureCount;
                if (this.failureCount >= 3) {
                    int pow = Math.min(5, this.failureCount - 3);
                    long waitFor = (long)(50.0 * Math.pow(2.0, pow));
                    LXOutput.error(this.getClass().getSimpleName() + " retrying " + String.valueOf(inetAddress) + " in " + waitFor + "ms (" + this.failureCount + " consecutive failures)");
                    this.sendAfter = this.lx.engine.nowMillis + waitFor;
                }
                this.disconnect(iox);
            }
        }
    }

    protected void didConnect() {
    }

    protected void disconnect(Exception x) {
        block13: {
            block11: {
                if (this.output != null) {
                    try {
                        try {
                            this.output.close();
                        }
                        catch (Exception exception) {
                            this.output = null;
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        this.output = null;
                        throw throwable;
                    }
                    this.output = null;
                }
            }
            if (this.socket != null) {
                try {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        this.socket = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.socket = null;
                    throw throwable;
                }
                this.socket = null;
            }
        }
        this.didDisconnect(x);
    }

    protected void didDisconnect(Exception x) {
    }

    @Override
    protected void onSend(int[] colors, LXOutput.GammaTable glut, double brightness) {
        this.connect();
        if (this.isConnected()) {
            try {
                this.output.write(this.getPacketData(colors, glut, brightness));
            }
            catch (IOException iox) {
                LXOutput.error(this.getClass().getSimpleName() + " exception writing to " + String.valueOf(this.socket.getInetAddress()) + ": " + iox.getLocalizedMessage());
                this.disconnect(iox);
            }
        }
    }

    protected byte[] getPacketData(int[] colors, LXOutput.GammaTable glut, double brightness) {
        this.updateDataBuffer(colors, glut, brightness);
        return this.getDataBuffer();
    }
}

