/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.LXListenableNormalizedParameter;

public class BooleanParameter
extends LXListenableNormalizedParameter {
    private Mode mode = Mode.TOGGLE;

    public BooleanParameter(String label) {
        this(label, false);
    }

    public BooleanParameter(String label, boolean on) {
        super(label, on ? 1.0 : 0.0);
    }

    @Override
    public BooleanParameter setMappable(boolean mappable) {
        super.setMappable(mappable);
        return this;
    }

    @Override
    public BooleanParameter setDescription(String description) {
        return (BooleanParameter)super.setDescription(description);
    }

    public BooleanParameter setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isOn() {
        return this.getValueb();
    }

    public boolean getValueb() {
        return this.getValue() > 0.0;
    }

    public BooleanParameter setValue(boolean value) {
        this.setValue(value ? 1.0 : 0.0);
        return this;
    }

    public BooleanParameter toggle() {
        this.setValue(!this.isOn());
        return this;
    }

    @Override
    protected double updateValue(double value) {
        return value > 0.0 ? 1.0 : 0.0;
    }

    @Override
    public double getNormalized() {
        return this.getValue() > 0.0 ? 1.0 : 0.0;
    }

    @Override
    public float getNormalizedf() {
        return (float)this.getNormalized();
    }

    @Override
    public BooleanParameter setNormalized(double normalized) {
        this.setValue(normalized >= 0.5);
        return this;
    }

    public BooleanParameter getTriggerSource() {
        return this;
    }

    public static enum Mode {
        TOGGLE,
        MOMENTARY;

    }
}

