/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.modulation.LXCompoundModulation;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXEngineThreadArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CompoundDiscreteParameter
extends DiscreteParameter
implements LXCompoundModulation.Target {
    private final LXEngineThreadArrayList<LXCompoundModulation> mutableModulations = new LXEngineThreadArrayList();
    public final List<LXCompoundModulation> modulations = Collections.unmodifiableList(this.mutableModulations);
    private final List<LXCompoundModulation.Listener> modulationListeners = new ArrayList<LXCompoundModulation.Listener>();

    @Override
    public final CompoundDiscreteParameter addModulationListener(LXCompoundModulation.Listener listener) {
        Objects.requireNonNull(listener, "May not add null CompoundDiscreteParameter.ModulationListener");
        if (this.modulationListeners.contains(listener)) {
            throw new IllegalStateException("Cannod add CompoundDiscreteParameter.ModulationListener listener twice: " + String.valueOf(listener));
        }
        this.modulationListeners.add(listener);
        return this;
    }

    @Override
    public final CompoundDiscreteParameter removeModulationListener(LXCompoundModulation.Listener listener) {
        this.modulationListeners.remove(listener);
        return this;
    }

    public CompoundDiscreteParameter(String label, int range) {
        super(label, 0, range);
    }

    public CompoundDiscreteParameter(String label, int min, int max) {
        super(label, min, min, max);
    }

    public CompoundDiscreteParameter(String label, int value, int min, int max) {
        super(label, value, min, max);
    }

    public CompoundDiscreteParameter(String label, String[] options) {
        super(label, options.length);
    }

    public CompoundDiscreteParameter(String label, String[] options, int value) {
        super(label, value, 0, options.length);
    }

    @Override
    public List<LXCompoundModulation> getModulations() {
        return this.modulations;
    }

    @Override
    public List<LXCompoundModulation> getUIThreadModulations() {
        return this.mutableModulations.getUIThreadList();
    }

    @Override
    public CompoundDiscreteParameter addModulation(LXCompoundModulation modulation) {
        if (this.mutableModulations.contains(modulation)) {
            throw new IllegalStateException("Cannot add the same modulation twice");
        }
        this.mutableModulations.add(modulation);
        for (LXCompoundModulation.Listener listener : this.modulationListeners) {
            listener.modulationAdded(this, modulation);
        }
        this.bang();
        return this;
    }

    @Override
    public CompoundDiscreteParameter removeModulation(LXCompoundModulation modulation) {
        this.mutableModulations.remove(modulation);
        for (LXCompoundModulation.Listener listener : this.modulationListeners) {
            listener.modulationRemoved(this, modulation);
        }
        this.bang();
        return this;
    }

    @Override
    public CompoundDiscreteParameter setUnits(LXParameter.Units units) {
        super.setUnits(units);
        return this;
    }

    @Override
    public CompoundDiscreteParameter setWrappable(boolean wrappable) {
        super.setWrappable(wrappable);
        return this;
    }

    @Override
    public CompoundDiscreteParameter setMappable(boolean mappable) {
        super.setMappable(mappable);
        return this;
    }

    @Override
    public CompoundDiscreteParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public double getBaseValue() {
        return super.getValue();
    }

    @Override
    public double getBaseNormalized() {
        if (this.range <= 1L) {
            return 0.0;
        }
        return (this.getBaseValue() - (double)this.minValue) / (double)(this.range - 1L);
    }

    @Override
    public int getBaseValuei() {
        return (int)this.getBaseValue();
    }

    @Override
    public int getBaseIndex() {
        return super.getIndex();
    }

    @Override
    public double getNormalized() {
        if (this.range <= 1L) {
            return 0.0;
        }
        double normalized = this.getNormalizedWithModulation(this.getBaseNormalized(), this.modulations);
        double quantize = this.normalizedToValue(normalized);
        return (quantize - (double)this.minValue) / (double)(this.range - 1L);
    }

    @Override
    public double getValue() {
        if (this.range <= 1L) {
            return 0.0;
        }
        if (this.mutableModulations.size() == 0) {
            return super.getValue();
        }
        return this.normalizedToValue(this.getNormalized());
    }
}

