/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.LXComponent;
import heronarts.lx.parameter.LXParameter;

public abstract class FunctionalParameter
implements LXParameter {
    private final String label;
    protected String description = null;
    private LXComponent parent;
    private String path;
    private LXParameter.Formatter formatter = null;

    public static FunctionalParameter create(String label, final Interface iface) {
        return new FunctionalParameter(label){

            @Override
            public double getValue() {
                return iface.getValue();
            }
        };
    }

    public static FunctionalParameter create(final Interface iface) {
        return new FunctionalParameter(){

            @Override
            public double getValue() {
                return iface.getValue();
            }
        };
    }

    protected FunctionalParameter() {
        this("FUNC-PARAM");
    }

    protected FunctionalParameter(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public FunctionalParameter setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public LXParameter setComponent(LXComponent parent, String path) {
        if (parent == null || path == null) {
            throw new IllegalArgumentException("May not set null component or path");
        }
        if (this.parent != null || this.path != null) {
            throw new IllegalStateException("Component already set on this modulator: " + String.valueOf(this));
        }
        this.parent = parent;
        this.path = path;
        return this;
    }

    @Override
    public LXComponent getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public LXParameter.Polarity getPolarity() {
        return LXParameter.Polarity.UNIPOLAR;
    }

    @Override
    public LXParameter.Formatter getFormatter() {
        return this.formatter != null ? this.formatter : this.getUnits();
    }

    @Override
    public FunctionalParameter setFormatter(LXParameter.Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    @Override
    public LXParameter.Units getUnits() {
        return LXParameter.Units.NONE;
    }

    @Override
    public void dispose() {
    }

    @Override
    public FunctionalParameter reset() {
        return this;
    }

    @Override
    public LXParameter setValue(double value) {
        throw new UnsupportedOperationException("FunctionalParameter does not support setValue()");
    }

    @Override
    public abstract double getValue();

    @Override
    public final String getLabel() {
        return this.label;
    }

    public static interface Interface {
        public double getValue();
    }
}

