/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.modulation.LXCompoundModulation;
import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;
import java.util.List;

public abstract class LXListenableNormalizedParameter
extends LXListenableParameter
implements LXNormalizedParameter {
    private double exponent = 1.0;
    private boolean wrappable = false;
    private LXNormalizedParameter.OscMode oscMode = LXNormalizedParameter.OscMode.NORMALIZED;

    protected LXListenableNormalizedParameter(String label, double value) {
        super(label, value);
    }

    public LXListenableNormalizedParameter setExponent(double exponent) {
        if (exponent <= 0.0) {
            throw new IllegalArgumentException("May not set zero or negative exponent");
        }
        this.exponent = exponent;
        return this;
    }

    @Override
    public double getExponent() {
        return this.exponent;
    }

    @Override
    public LXListenableNormalizedParameter setUnits(LXParameter.Units units) {
        super.setUnits(units);
        switch (units) {
            case INTEGER: 
            case SECONDS: 
            case MILLISECONDS: 
            case MILLISECONDS_RAW: 
            case MIDI_NOTE: 
            case CLOCK: {
                this.setOscMode(LXNormalizedParameter.OscMode.ABSOLUTE);
                break;
            }
        }
        return this;
    }

    public LXListenableNormalizedParameter setOscMode(LXNormalizedParameter.OscMode oscMode) {
        this.oscMode = oscMode;
        return this;
    }

    @Override
    public LXNormalizedParameter.OscMode getOscMode() {
        return this.oscMode;
    }

    public LXListenableNormalizedParameter setWrappable(boolean wrappable) {
        this.wrappable = wrappable;
        return this;
    }

    @Override
    public boolean isWrappable() {
        return this.wrappable;
    }

    protected double getNormalizedWithModulation(double normalized, List<? extends LXCompoundModulation> modulations) {
        for (LXCompoundModulation lXCompoundModulation : modulations) {
            normalized += lXCompoundModulation.getModulationAmount();
        }
        if (this.isWrappable()) {
            if (normalized < 0.0) {
                return 1.0 + normalized % 1.0;
            }
            if (normalized > 1.0) {
                return normalized % 1.0;
            }
            return normalized;
        }
        return LXUtils.constrain(normalized, 0.0, 1.0);
    }

    public LXListenableNormalizedParameter incrementNormalized(double amount) {
        return this.incrementNormalized(amount, this.isWrappable());
    }

    public LXListenableNormalizedParameter incrementNormalized(double amount, boolean wrap) {
        double normalized = this.getBaseNormalized();
        normalized += amount;
        if (wrap) {
            if (normalized > 1.0) {
                normalized %= 1.0;
            } else if (normalized < 0.0) {
                normalized = 1.0 + normalized % 1.0;
            }
        }
        return (LXListenableNormalizedParameter)this.setNormalized(normalized);
    }
}

