/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.LXComponent;
import heronarts.lx.LXPath;
import heronarts.lx.midi.MidiNote;
import heronarts.lx.parameter.AggregateParameter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public interface LXParameter
extends LXPath {
    default public AggregateParameter getParentParameter() {
        return null;
    }

    public LXParameter setComponent(LXComponent var1, String var2);

    public Units getUnits();

    public Formatter getFormatter();

    public LXParameter setFormatter(Formatter var1);

    public Polarity getPolarity();

    public void dispose();

    public Object reset();

    public LXParameter setValue(double var1);

    public double getValue();

    default public float getValuef() {
        return (float)this.getValue();
    }

    default public double getBaseValue() {
        return this.getValue();
    }

    default public float getBaseValuef() {
        return (float)this.getBaseValue();
    }

    @Override
    public String getLabel();

    default public LXParameter setMappable(boolean mappable) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass()) + " does not support setMappable()");
    }

    default public boolean isMappable() {
        return false;
    }

    public static class Collection
    extends LinkedHashMap<String, LXParameter> {
        private static final long serialVersionUID = -7473252361485696112L;

        public Collection add(String path, LXParameter parameter) {
            if (this.containsKey(path)) {
                throw new IllegalStateException("Cannot add duplicate parameter path to collection: " + path);
            }
            if (this.containsValue(parameter)) {
                throw new IllegalStateException("Cannot add parameter to same collection twice: " + String.valueOf(parameter));
            }
            this.put(path, parameter);
            return this;
        }

        public Collection reset() {
            for (LXParameter p : this.values()) {
                p.reset();
            }
            return this;
        }
    }

    public static interface Formatter {
        public static final Formatter DECIMAL_MAX_2_PLACES = Formatter.newDecimalFormatter("#.##");

        public String format(double var1);

        public static Formatter newDecimalFormatter(String decimalFormat) {
            return Formatter.newDecimalFormatter(new DecimalFormat(decimalFormat));
        }

        public static Formatter newDecimalFormatter(final DecimalFormat decimalFormat) {
            return new Formatter(){

                @Override
                public String format(double value) {
                    return decimalFormat.format(value);
                }
            };
        }
    }

    public static class Monitor {
        private final LXParameter parameter;
        private double lastValue;

        public Monitor(LXParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException("Cannot create LXParameter.Monitor for null");
            }
            this.parameter = parameter;
            this.lastValue = parameter.getValue();
        }

        public boolean changed() {
            double value = this.parameter.getValue();
            boolean changed = value != this.lastValue;
            this.lastValue = value;
            return changed;
        }
    }

    public static class MultiMonitor {
        private final List<Monitor> monitors = new ArrayList<Monitor>();

        public MultiMonitor(LXParameter ... parameters) {
            LXParameter[] lXParameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                LXParameter parameter = lXParameterArray[n2];
                this.addParameter(parameter);
                ++n2;
            }
        }

        public MultiMonitor addParameter(LXParameter parameter) {
            this.monitors.add(new Monitor(parameter));
            return this;
        }

        public boolean changed() {
            boolean changed = false;
            for (Monitor monitor : this.monitors) {
                if (!monitor.changed()) continue;
                changed = true;
            }
            return changed;
        }
    }

    public static enum Polarity {
        UNIPOLAR,
        BIPOLAR;


        public String toString() {
            switch (this) {
                case BIPOLAR: {
                    return "\u2194";
                }
            }
            return "\u2192";
        }
    }

    public static enum Units implements Formatter
    {
        NONE,
        INTEGER,
        SECONDS,
        MILLISECONDS,
        MILLISECONDS_RAW,
        DECIBELS,
        HERTZ,
        MIDI_NOTE,
        DEGREES,
        RADIANS,
        PERCENT,
        PERCENT_NORMALIZED,
        CLOCK;


        @Override
        public String format(double value) {
            switch (this) {
                case INTEGER: {
                    return String.format("%d", (int)value);
                }
                case PERCENT: {
                    return String.format("%d%%", (int)value);
                }
                case PERCENT_NORMALIZED: {
                    return String.format("%d%%", (int)(100.0 * value));
                }
                case SECONDS: {
                    value *= 1000.0;
                }
                case MILLISECONDS: 
                case MILLISECONDS_RAW: {
                    if (value < 1000.0) {
                        return String.format("%dms", (int)value);
                    }
                    if (value < 60000.0) {
                        return String.format("%.2fs", value / 1000.0);
                    }
                    if (value < 3600000.0) {
                        int minutes = (int)(value / 60000.0);
                        int seconds = (int)(value % 60000.0 / 1000.0);
                        return String.format("%d:%02d", minutes, seconds);
                    }
                    int hours = (int)(value / 3600000.0);
                    int minutes = (int)((value %= 3600000.0) / 60000.0);
                    int seconds = (int)(value % 60000.0 / 1000.0);
                    return String.format("%d:%02d:%02d", hours, minutes, seconds);
                }
                case HERTZ: {
                    if (value >= 10000.0) {
                        return String.format("%.1fkHz", value / 1000.0);
                    }
                    if (value >= 1000.0) {
                        return String.format("%.2fkHz", value / 1000.0);
                    }
                    if (value >= 100.0) {
                        return String.format("%.0fHz", value);
                    }
                    if (value >= 10.0) {
                        return String.format("%.1fHz", value);
                    }
                    return String.format("%.2fHz", value);
                }
                case DECIBELS: {
                    return String.format("%.1fdB", value);
                }
                case MIDI_NOTE: {
                    return MidiNote.getPitchString((int)value);
                }
                case DEGREES: {
                    return String.format("%d\u00b0", (int)value);
                }
                case CLOCK: {
                    return String.format("%02d", (int)value);
                }
            }
            return String.format("%.2f", value);
        }

        public double parseDouble(String value) throws NumberFormatException {
            double timeMultiple = 1.0;
            switch (this) {
                case MILLISECONDS: 
                case MILLISECONDS_RAW: {
                    if (value.indexOf(":") >= 0 || this == MILLISECONDS) {
                        timeMultiple = 1000.0;
                    }
                }
                case SECONDS: {
                    double raw = 0.0;
                    String[] stringArray = value.split(":");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String part = stringArray[n2];
                        raw = raw * 60.0 + (part.length() > 0 ? Double.parseDouble(part) : 0.0);
                        ++n2;
                    }
                    return timeMultiple * raw;
                }
                case PERCENT_NORMALIZED: {
                    return 0.01 * Double.parseDouble(value);
                }
            }
            return Double.parseDouble(value);
        }
    }
}

