/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.LXListenableParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

public class MutableParameter
extends LXListenableParameter {
    private boolean hasMinimum = false;
    private boolean hasMaximum = false;
    private double minimum = 0.0;
    private double maximum = 0.0;

    public MutableParameter() {
    }

    public MutableParameter(String label) {
        super(label);
    }

    public MutableParameter(String label, double value) {
        super(label, value);
    }

    public MutableParameter(double value) {
        super(value);
    }

    public MutableParameter increment() {
        return (MutableParameter)this.setValue(this.getValue() + 1.0);
    }

    public MutableParameter decrement() {
        return (MutableParameter)this.setValue(this.getValue() - 1.0);
    }

    public MutableParameter setMinimum(double minimum) {
        if (this.hasMaximum && minimum > this.maximum) {
            throw new IllegalArgumentException("Cannot set MutableParameter minimum > maximum");
        }
        this.minimum = minimum;
        this.hasMinimum = true;
        this.setValue(this.getValue());
        return this;
    }

    public MutableParameter setMaximum(double maximum) {
        if (this.hasMinimum && maximum < this.minimum) {
            throw new IllegalArgumentException("Cannot set MutableParameter maximum < minimum");
        }
        this.maximum = maximum;
        this.hasMaximum = true;
        this.setValue(this.getValue());
        return this;
    }

    @Override
    public MutableParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MutableParameter setFormatter(LXParameter.Formatter formatter) {
        super.setFormatter(formatter);
        return this;
    }

    @Override
    public MutableParameter setMappable(boolean mappable) {
        super.setMappable(mappable);
        return this;
    }

    @Override
    public MutableParameter setPolarity(LXParameter.Polarity polarity) {
        super.setPolarity(polarity);
        return this;
    }

    @Override
    public MutableParameter setUnits(LXParameter.Units units) {
        super.setUnits(units);
        return this;
    }

    @Override
    protected double updateValue(double value) {
        if (this.hasMinimum) {
            value = LXUtils.max(value, this.minimum);
        }
        if (this.hasMaximum) {
            value = LXUtils.min(value, this.maximum);
        }
        return value;
    }

    public int getValuei() {
        return (int)this.getValue();
    }
}

