/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.LXComponent;
import heronarts.lx.parameter.LXNormalizedParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.utils.LXUtils;

public class NormalizedParameter
implements LXNormalizedParameter {
    private LXComponent parent = null;
    private String path = null;
    private final String label;
    private String description = null;
    private double value = 0.0;
    private boolean mappable = true;
    private LXParameter.Formatter formatter = null;

    public NormalizedParameter(String label) {
        this(label, 0.0);
    }

    public NormalizedParameter(String label, double value) {
        this.label = label;
        this.value = value;
    }

    @Override
    public NormalizedParameter setComponent(LXComponent component, String path) {
        if (component == null || path == null) {
            throw new IllegalArgumentException("May not set null component or path");
        }
        if (this.parent != null || this.path != null) {
            throw new IllegalStateException("Component already set on this modulator: " + String.valueOf(this));
        }
        this.parent = component;
        this.path = path;
        return this;
    }

    @Override
    public LXComponent getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public NormalizedParameter setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public LXParameter.Formatter getFormatter() {
        return this.formatter != null ? this.formatter : this.getUnits();
    }

    @Override
    public NormalizedParameter setFormatter(LXParameter.Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    @Override
    public LXParameter.Units getUnits() {
        return LXParameter.Units.NONE;
    }

    @Override
    public LXParameter.Polarity getPolarity() {
        return LXParameter.Polarity.UNIPOLAR;
    }

    @Override
    public void dispose() {
    }

    @Override
    public NormalizedParameter reset() {
        this.value = 0.0;
        return this;
    }

    @Override
    public NormalizedParameter setValue(double value) {
        this.value = LXUtils.constrain(value, 0.0, 1.0);
        return this;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public NormalizedParameter setNormalized(double value) {
        return this.setValue(value);
    }

    @Override
    public double getNormalized() {
        return this.value;
    }

    @Override
    public float getNormalizedf() {
        return (float)this.getNormalized();
    }

    @Override
    public double getExponent() {
        return 1.0;
    }

    @Override
    public boolean isMappable() {
        return this.mappable;
    }
}

