/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.LX;
import heronarts.lx.Tempo;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.LXParameterListener;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.parameter.TriggerParameter;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuantizedTriggerParameter
extends TriggerParameter {
    private final LX lx;
    private ObjectParameter<Tempo.Quantization> quantization;
    public final BooleanParameter pending;
    public final TriggerParameter out;
    private int semaphore = 0;
    private Runnable onSchedule = null;
    private QuantizedTriggerFunction onQuantizedTrigger = null;
    private OutputMode outputMode = OutputMode.SINGLE;
    private static final Map<Tempo.Division, List<QuantizedTriggerParameter>> pendingInstances = new HashMap<Tempo.Division, List<QuantizedTriggerParameter>>();
    private final LXParameterListener quantizationListener = this::_onQuantizationChanged;

    static {
        Tempo.Division[] divisionArray = Tempo.Division.values();
        int n = divisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tempo.Division division = divisionArray[n2];
            pendingInstances.put(division, new ArrayList());
            ++n2;
        }
    }

    private void _onQuantizationChanged(LXParameter p) {
        if (this.getQuantization() == Tempo.Quantization.NONE) {
            this._resolve(true);
        } else if (this.pending.isOn()) {
            this._addPendingInstance();
        }
    }

    private void _addPendingInstance() {
        List<QuantizedTriggerParameter> pending;
        Tempo.Division division = this.quantization.getObject().getDivision();
        if (division != null && !(pending = pendingInstances.get(division)).contains(this)) {
            pending.add(this);
        }
    }

    public QuantizedTriggerParameter(LX lx, String label) {
        this(lx, label, (ObjectParameter<Tempo.Quantization>)null, (Runnable)null);
    }

    public QuantizedTriggerParameter(LX lx, String label, ObjectParameter<Tempo.Quantization> quantization) {
        this(lx, label, quantization, (Runnable)null);
    }

    public QuantizedTriggerParameter(LX lx, String label, Runnable onTrigger) {
        this(lx, label, null, onTrigger);
    }

    public QuantizedTriggerParameter(LX lx, String label, QuantizedTriggerFunction onTrigger) {
        this(lx, label, (ObjectParameter<Tempo.Quantization>)null, (Runnable)null);
        this.onQuantizedTrigger(onTrigger);
    }

    public QuantizedTriggerParameter(LX lx, String label, ObjectParameter<Tempo.Quantization> quantization, QuantizedTriggerFunction onTrigger) {
        this(lx, label, quantization, (Runnable)null);
        this.onQuantizedTrigger(onTrigger);
    }

    public QuantizedTriggerParameter(LX lx, String label, ObjectParameter<Tempo.Quantization> quantization, Runnable onTrigger) {
        super(label);
        this.lx = lx;
        this.out = new TriggerParameter(label).onTrigger(onTrigger);
        this.pending = new BooleanParameter(label + "Pending").setMode(BooleanParameter.Mode.MOMENTARY);
        this.setQuantization(quantization);
    }

    public QuantizedTriggerParameter setQuantization(ObjectParameter<Tempo.Quantization> quantization) {
        if (this.quantization != null) {
            this.quantization.removeListener(this.quantizationListener);
        }
        this.quantization = quantization;
        if (this.quantization == null || !this.quantization.getObject().hasDivision()) {
            this._resolve(true);
        }
        if (this.quantization != null) {
            this.quantization.addListener(this.quantizationListener, true);
        }
        return this;
    }

    @Override
    public QuantizedTriggerParameter setDescription(String description) {
        super.setDescription(description);
        this.out.setDescription(description);
        return this;
    }

    @Override
    public QuantizedTriggerParameter onTrigger(Runnable onTrigger) {
        this.out.onTrigger(onTrigger);
        return this;
    }

    public QuantizedTriggerParameter setOutputMode(OutputMode outputMode) {
        this.outputMode = outputMode;
        if (this.outputMode == OutputMode.SINGLE) {
            this.semaphore = LXUtils.min(1, this.semaphore);
        }
        return this;
    }

    private void increment() {
        switch (this.outputMode) {
            case MULTIPLE: {
                ++this.semaphore;
                break;
            }
            default: {
                this.semaphore = 1;
            }
        }
    }

    private Tempo.Quantization getQuantization() {
        return this.quantization == null ? Tempo.Quantization.NONE : this.quantization.getObject();
    }

    public QuantizedTriggerParameter onSchedule(Runnable onSchedule) {
        this.onSchedule = onSchedule;
        return this;
    }

    public QuantizedTriggerParameter onQuantizedTrigger(QuantizedTriggerFunction onQuantizedTrigger) {
        if (this.onQuantizedTrigger != null) {
            LX.error(new Exception(), "WARNING / SHOULDFIX: Overwriting previous onQuantizedTrigger on QuantizedTriggerParameter: " + this.getCanonicalPath());
        }
        this.onQuantizedTrigger = onQuantizedTrigger;
        return this;
    }

    @Override
    protected void _onTrigger() {
        this.increment();
        Tempo.Quantization quantization = this.getQuantization();
        if (!quantization.hasDivision() || quantization.getDivision().isActive()) {
            this._resolve(false);
        } else {
            this.pending.setValue(true);
            this._addPendingInstance();
            if (this.onSchedule != null) {
                this.onSchedule.run();
            }
        }
    }

    public void cancel() {
        this.semaphore = 0;
        this.pending.setValue(false);
    }

    public void resolve() {
        this._resolve(this.pending.isOn());
    }

    private void _resolve(boolean quantized) {
        this.pending.setValue(false);
        int i = 0;
        while (i < this.semaphore) {
            this.out.trigger();
            if (this.onQuantizedTrigger != null) {
                this.onQuantizedTrigger.onTrigger(quantized);
            }
            ++i;
        }
        this.semaphore = 0;
    }

    @Override
    public BooleanParameter getTriggerSource() {
        return this.out;
    }

    @Override
    public void dispose() {
        this.cancel();
        this.setQuantization(null);
        this.pending.dispose();
        this.out.dispose();
        super.dispose();
    }

    public static void resolve(LX lx, Tempo.Division division) {
        List<QuantizedTriggerParameter> instances = pendingInstances.get(division);
        if (instances.isEmpty()) {
            return;
        }
        QuantizedTriggerParameter[] copy = instances.toArray(new QuantizedTriggerParameter[0]);
        instances.clear();
        QuantizedTriggerParameter[] quantizedTriggerParameterArray = copy;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            QuantizedTriggerParameter trigger = quantizedTriggerParameterArray[n2];
            if (trigger.lx == lx && trigger.pending.isOn() && trigger.getQuantization().getDivision() == division) {
                trigger._resolve(true);
            }
            ++n2;
        }
    }

    public static class Launch
    extends QuantizedTriggerParameter {
        public Launch(LX lx, String label) {
            this(lx, label, (Runnable)null);
        }

        public Launch(LX lx, String label, Runnable onTrigger) {
            super(lx, label, lx.engine.tempo.launchQuantization, onTrigger);
        }

        public Launch(LX lx, String label, QuantizedTriggerFunction onTrigger) {
            super(lx, label, lx.engine.tempo.launchQuantization, onTrigger);
        }
    }

    public static enum OutputMode {
        SINGLE,
        MULTIPLE;

    }

    public static interface QuantizedTriggerFunction {
        public void onTrigger(boolean var1);
    }
}

