/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.parameter;

import heronarts.lx.parameter.AggregateParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.LXParameter;
import java.util.Calendar;

public class TimeParameter
extends AggregateParameter {
    public static final int HOURS_PER_DAY = 24;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public final DiscreteParameter hours = new DiscreteParameter("Hours", 0, 24).setUnits(LXParameter.Units.CLOCK).setDescription("Hours of the day (0-23)");
    public final DiscreteParameter minutes = new DiscreteParameter("Minutes", 0, 60).setUnits(LXParameter.Units.CLOCK).setDescription("Minutes of the hour (0-59)");
    public final DiscreteParameter seconds = new DiscreteParameter("Seconds", 0, 60).setUnits(LXParameter.Units.CLOCK).setDescription("Seconds of the minute (0-59)");

    public TimeParameter(String label) {
        super(label);
        this.addSubparameter("hours", this.hours);
        this.addSubparameter("minutes", this.minutes);
        this.addSubparameter("seconds", this.seconds);
    }

    @Override
    public TimeParameter setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    public TimeParameter setTime(int hours, int minutes, int seconds) {
        if (hours < 0) {
            throw new IllegalArgumentException("TimeParameter hours may not be < 0 (" + hours + ")");
        }
        if (hours >= 24) {
            throw new IllegalArgumentException("TimeParameter hours may not be > 23 (" + hours + ")");
        }
        if (minutes < 0) {
            throw new IllegalArgumentException("TimeParameter minutes may not be < 0 (" + minutes + ")");
        }
        if (minutes >= 60) {
            throw new IllegalArgumentException("TimeParameter minutes may not be > 59 (" + minutes + ")");
        }
        if (seconds < 0) {
            throw new IllegalArgumentException("TimeParameter seconds may not be < 0 (" + seconds + ")");
        }
        if (seconds > 3600) {
            throw new IllegalArgumentException("TimeParameter seconds may not be > 59 (" + seconds + ")");
        }
        return this.setTime(TimeParameter.getSecondsOfDay(hours, minutes, seconds));
    }

    public TimeParameter setTime(int secondsOfDay) {
        if (secondsOfDay < 0) {
            throw new IllegalArgumentException("TimeParameter may not be < 0 (" + String.valueOf(this.hours) + ")");
        }
        if (secondsOfDay >= 86400) {
            throw new IllegalArgumentException("TimeParameter hours may not be > 86399(" + secondsOfDay + ")");
        }
        this.setValue(secondsOfDay);
        return this;
    }

    public int getSecondsOfDay() {
        return (int)this.getValue();
    }

    public static int getSecondsOfDay(int hours, int minutes, int seconds) {
        return hours * 3600 + minutes * 60 + seconds;
    }

    public static int getSecondsOfDay(Calendar calendar) {
        return TimeParameter.getSecondsOfDay(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    @Override
    protected void updateSubparameters(double value) {
        int secondsOfDay = (int)value;
        this.hours.setValue(secondsOfDay / 3600);
        this.minutes.setValue(secondsOfDay % 3600 / 60);
        this.seconds.setValue(secondsOfDay % 60);
    }

    @Override
    protected void onSubparameterUpdate(LXParameter p) {
        this.setTime(this.hours.getValuei(), this.minutes.getValuei(), this.seconds.getValuei());
    }
}

