/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.audio;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.LXComponentName;
import heronarts.lx.audio.SoundObject;
import heronarts.lx.audio.SoundStage;
import heronarts.lx.color.LXColor;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.transform.LXVector;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Audio")
@LXComponentName(value="Sound Object")
@LXComponent.Description(value="Places an orb of light in the position of a sound object")
public class SoundObjectPattern
extends LXPattern {
    public final Engine engine;

    public SoundObjectPattern(LX lx) {
        super(lx);
        this.engine = new Engine(lx);
        this.addParameter("baseSize", this.engine.baseSize);
        this.addParameter("signalToSize", this.engine.signalToSize);
        this.addParameter("fadePercent", this.engine.contrast);
        this.addParameter("baseBrightness", this.engine.baseLevel);
        this.addParameter("modulationInput", this.engine.modulationInput);
        this.addParameter("modulationToSize", this.engine.modulationToSize);
        this.addParameter("modulationToBrt", this.engine.modulationToLevel);
        this.addParameter("signalToBrt", this.engine.signalToLevel);
        this.addParameter("selector", this.engine.selector);
        this.addParameter("positionMode", this.engine.positionMode);
        this.addParameter("shapeMode1", this.engine.shapeMode1);
        this.addParameter("shapeMode2", this.engine.shapeMode2);
        this.addParameter("shapeLerp", this.engine.shapeLerp);
        this.addParameter("scopeAmount", this.engine.scopeAmount);
        this.addParameter("scopeTimeMs", this.engine.scopeTimeMs);
    }

    @Override
    protected void run(double deltaMs) {
        this.engine.run(this.model, this.colors, deltaMs);
    }

    public static class Engine {
        public final SoundObject.Selector selector = new SoundObject.Selector("Object").setDescription("Which sound object to render");
        public final EnumParameter<SoundStage.ObjectPositionMode> positionMode = new EnumParameter<SoundStage.ObjectPositionMode>("Position Mode", SoundStage.ObjectPositionMode.ABSOLUTE).setDescription("How to calculate the sound object position");
        public final EnumParameter<ShapeMode> shapeMode1 = new EnumParameter<ShapeMode>("Shape Mode 1", ShapeMode.ORB).setDescription("How to render the sound object shape");
        public final EnumParameter<ShapeMode> shapeMode2 = new EnumParameter<ShapeMode>("Shape Mode 2", ShapeMode.BOX).setDescription("How to render the sound object shape");
        public final CompoundParameter shapeLerp = new CompoundParameter("Shaper Lerp").setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Blending between two object shapes");
        public final CompoundParameter baseSize = new CompoundParameter("Size", 0.1).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Base Size of the sound object");
        public final CompoundParameter baseLevel = new CompoundParameter("Level", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Base brightness level");
        public final CompoundParameter contrast = new CompoundParameter("Contrast", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Percentage of the total size which fades out");
        public final CompoundParameter modulationInput = new CompoundParameter("Mod", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Manual modulation input");
        public final CompoundParameter modulationToSize = new CompoundParameter("M>Sz", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of modulation input applied to size");
        public final CompoundParameter modulationToLevel = new CompoundParameter("M>Lev", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of modulation input applied to brightness");
        public final CompoundParameter signalToSize = new CompoundParameter("Sig>Sz", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount by which signal level modulates orb size");
        public final CompoundParameter signalToLevel = new CompoundParameter("Sig>Lev", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount by which signal level modulates overall brightness");
        public final CompoundParameter scopeAmount = new CompoundParameter("ScpAmt", 0.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Amount of audio scope modulation, modulating brightness by input history");
        public final CompoundParameter scopeTimeMs = new CompoundParameter("ScpTim", 2000.0, 100.0, 30000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Total amount of time of scope history");
        private final LX lx;
        private static final int MAX_SCOPE_MS = 30000;
        private final double[] scope = new double[30000];
        private int scopeIndex = 0;
        private static final double INV_MAX_DISTANCE = 1.0 / Math.sqrt(3.0);
        private final LXVector so = new LXVector();

        public Engine(LX lx) {
            this.lx = lx;
        }

        private double modulationFactor(double value, LXParameter lerpParam) {
            double lerp = lerpParam.getValue();
            if (lerp > 0.0) {
                return LXUtils.lerp(1.0, value, lerp);
            }
            return LXUtils.lerp(1.0, 1.0 - value, -lerp);
        }

        public void run(LXModel model, int[] colors, double deltaMs) {
            double mod = this.modulationInput.getValue();
            double level = 100.0 * this.baseLevel.getValue() * this.modulationFactor(mod, this.modulationToLevel);
            double size = this.baseSize.getValue() * this.modulationFactor(mod, this.modulationToSize);
            double signal = 0.0;
            SoundObject soundObject = (SoundObject)this.selector.getObject();
            if (soundObject != null) {
                signal = soundObject.getNormalized();
                this.lx.engine.audio.soundStage.getNormalizedObjectPosition(soundObject, this.positionMode.getEnum(), model, this.so);
            } else {
                this.so.set(0.5f, 0.5f, 0.5f);
            }
            level *= this.modulationFactor(signal, this.signalToLevel);
            size *= this.modulationFactor(signal, this.signalToSize);
            int scopeSteps = (int)deltaMs;
            double currentScope = this.scope[this.scopeIndex];
            double scopeIncrement = (signal - currentScope) / (double)scopeSteps;
            int i = 0;
            while (i < (int)deltaMs) {
                this.scopeIndex = (this.scopeIndex + 1) % this.scope.length;
                this.scope[this.scopeIndex] = currentScope += scopeIncrement;
                ++i;
            }
            double fadePercent = size * (1.0 - this.contrast.getValue());
            double fadePercentInv = 1.0 / fadePercent;
            double scopeAmount = this.scopeAmount.getValue();
            double scopeTimeMs = this.scopeTimeMs.getValue();
            double fadeStart = size - fadePercent;
            float shapeLerp = this.shapeLerp.getValuef();
            ShapeFunction distance1 = shapeLerp < 1.0f ? this.shapeMode1.getEnum().function : ShapeFunction.NONE;
            ShapeFunction distance2 = shapeLerp > 0.0f ? this.shapeMode2.getEnum().function : ShapeFunction.NONE;
            LXPoint[] lXPointArray = model.points;
            int n = model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                float dist = LXUtils.lerpf(distance1.getDistance(p, this.so), distance2.getDistance(p, this.so), shapeLerp);
                int scopeOffset = (int)((double)dist * INV_MAX_DISTANCE * scopeTimeMs);
                double scopeFactor = 1.0;
                if (scopeOffset < this.scope.length) {
                    int scopePosition = (this.scopeIndex + this.scope.length - scopeOffset) % this.scope.length;
                    scopeFactor = LXUtils.lerp(1.0, this.scope[scopePosition], scopeAmount);
                }
                double max = level * scopeFactor;
                double falloff = max * fadePercentInv;
                colors[p.index] = LXColor.gray(LXUtils.constrain(max - falloff * ((double)dist - fadeStart), 0.0, max));
                ++n2;
            }
        }
    }

    public static interface ShapeFunction {
        public static final ShapeFunction NONE = (p, so) -> 0.0f;

        public float getDistance(LXPoint var1, LXVector var2);
    }

    public static enum ShapeMode {
        ORB("Orb", (p, so) -> LXUtils.distf(p.xn, p.yn, p.zn, so.x, so.y, so.z)),
        BOX("Box", (p, so) -> LXUtils.maxf(Math.abs(p.xn - so.x), Math.abs(p.yn - so.y), Math.abs(p.zn - so.z))),
        X("X", (p, so) -> Math.abs(p.xn - so.x)),
        Y("Y", (p, so) -> Math.abs(p.yn - so.y)),
        Z("Z", (p, so) -> Math.abs(p.zn - so.z));

        private final String label;
        private final ShapeFunction function;

        private ShapeMode(String label, ShapeFunction function) {
            this.label = label;
            this.function = function;
        }

        public String toString() {
            return this.label;
        }
    }
}

