/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.color;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.color.LinkedColorParameter;
import heronarts.lx.model.LXPoint;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.pattern.LXPattern;

@LXCategory(value="Color")
@LXComponent.Description(value="Generates stripes of alternating colors")
public class AlternatingPattern
extends LXPattern {
    public final LinkedColorParameter firstColor = new LinkedColorParameter("First Color").setDescription("First color to use");
    public final LinkedColorParameter secondColor = new LinkedColorParameter("Second Color").setDescription("Second color to use");
    public final DiscreteParameter stripeLength = new DiscreteParameter("Length", 1, 10).setDescription("Number of pixels to go before switching colors");

    public AlternatingPattern(LX lx) {
        this(lx, -1, -16776961);
        this.firstColor.mode.setValue((Object)LinkedColorParameter.Mode.PALETTE);
        this.firstColor.index.setValue(1.0);
        this.secondColor.mode.setValue((Object)LinkedColorParameter.Mode.PALETTE);
        this.secondColor.index.setValue(2.0);
    }

    public AlternatingPattern(LX lx, int firstColor, int secondColor) {
        super(lx);
        this.firstColor.setColor(firstColor);
        this.secondColor.setColor(secondColor);
        this.addParameter("firstColor", this.firstColor);
        this.addParameter("secondColor", this.secondColor);
        this.addParameter("stripeLength", this.stripeLength);
    }

    @Override
    public void run(double deltaMs) {
        int stripeLength = this.stripeLength.getValuei();
        int color1 = this.firstColor.calcColor();
        int color2 = this.secondColor.calcColor();
        int i = 0;
        LXPoint[] lXPointArray = this.model.points;
        int n = this.model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            int phase = i / stripeLength % 2;
            this.colors[p.index] = phase == 0 ? color1 : color2;
            ++i;
            ++n2;
        }
    }
}

