/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.form;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.LXLayer;
import heronarts.lx.LXSerializable;
import heronarts.lx.color.LXColor;
import heronarts.lx.model.LXPoint;
import heronarts.lx.osc.LXOscComponent;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.transform.LXParameterizedMatrix;
import heronarts.lx.utils.LXUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@LXCategory(value="Form")
@LXComponent.Description(value="Renders multiple overlayed planes through the 3D space")
public class PlanesPattern
extends LXPattern {
    public static final int MAX_PLANES = 8;
    public final List<Plane> planes;
    private final LXPoint point = new LXPoint();
    public final CompoundParameter yaw = new CompoundParameter("Yaw", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Yaw rotation");
    public final CompoundParameter pitch = new CompoundParameter("Pitch", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Pitch rotation");
    public final CompoundParameter roll = new CompoundParameter("Roll", 0.0, 360.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setDescription("Roll rotation");
    private final LXParameterizedMatrix transform = new LXParameterizedMatrix();
    private static final String KEY_PLANES = "planes";

    public PlanesPattern(LX lx) {
        super(lx);
        this.addParameter("yaw", this.yaw);
        this.addParameter("pitch", this.pitch);
        this.addParameter("roll", this.roll);
        this.transform.addParameter(this.yaw);
        this.transform.addParameter(this.pitch);
        this.transform.addParameter(this.roll);
        ArrayList<Plane> mutablePlanes = new ArrayList<Plane>();
        int i = 0;
        while (i < 8) {
            Plane plane = new Plane(lx, i);
            this.addLayer(plane);
            mutablePlanes.add(plane);
            ++i;
        }
        this.planes = Collections.unmodifiableList(mutablePlanes);
        Plane plane = this.planes.get(0);
        this.setRemoteControls(plane.level, plane.position, plane.width, plane.contrast, plane.tilt, plane.tiltPosition, plane.spin, plane.spinPosition, plane.positionMin, plane.positionMax, plane.widthMin, plane.widthMax, plane.axis);
    }

    @Override
    public void run(double deltaMs) {
        this.setColors(-16777216);
        this.transform.update(matrix -> matrix.translate(0.5f, 0.5f, 0.5f).rotateZ((float)Math.toRadians(-this.roll.getValue())).rotateX((float)Math.toRadians(-this.pitch.getValue())).rotateY((float)Math.toRadians(-this.yaw.getValue())).translate(-0.5f, -0.5f, -0.5f));
    }

    @Override
    public void save(LX lx, JsonObject obj) {
        super.save(lx, obj);
        obj.add(KEY_PLANES, (JsonElement)LXSerializable.Utils.toArray(lx, this.planes));
    }

    @Override
    public void load(LX lx, JsonObject obj) {
        super.load(lx, obj);
        if (obj.has(KEY_PLANES)) {
            JsonArray planesArray = obj.getAsJsonArray(KEY_PLANES);
            int i = 0;
            for (JsonElement planeElement : planesArray) {
                this.planes.get(i++).load(lx, planeElement.getAsJsonObject());
            }
        }
    }

    public static enum Axis {
        X("X-axis", (p, a) -> a.invSqrt * Math.abs((p.xn - a.ap) * a.a + (p.yn - a.bp) * a.b + (p.zn - a.cp) * a.c)),
        Y("Y-axis", (p, a) -> a.invSqrt * Math.abs((p.yn - a.ap) * a.a + (p.zn - a.bp) * a.b + (p.xn - a.cp) * a.c)),
        Z("Z-axis", (p, a) -> a.invSqrt * Math.abs((p.zn - a.ap) * a.a + (p.xn - a.bp) * a.b + (p.yn - a.cp) * a.c)),
        FREE("Free", (p, a) -> a.invSqrt * Math.abs((p.xn - a.ap) * a.a + (p.yn - a.bp) * a.b + (p.zn - a.cp) * a.c + a.d)),
        RC("R-center", (p, a) -> LXUtils.distf(p.xn, p.yn, p.zn, 0.5f, 0.5f, 0.5f) - a.d),
        RO("R-origin", (p, a) -> p.rn - a.d);

        public final String label;
        public final AxisFunction function;

        private Axis(String label, AxisFunction function) {
            this.label = label;
            this.function = function;
        }

        public String toString() {
            return this.label;
        }

        public boolean hasRotationControls() {
            switch (this) {
                case X: 
                case Y: 
                case Z: {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AxisFunction {
        public float getDistance(LXPoint var1, PlaneConstants var2);
    }

    public class Plane
    extends LXLayer
    implements LXOscComponent {
        public final int index;
        public final BooleanParameter active;
        public final EnumParameter<Axis> axis;
        public final CompoundParameter level;
        public final CompoundParameter position;
        public final BoundedParameter positionMin;
        public final BoundedParameter positionMax;
        public final CompoundParameter width;
        public final BoundedParameter widthMin;
        public final BoundedParameter widthMax;
        public final CompoundParameter contrast;
        public final CompoundParameter tiltPosition;
        public final CompoundParameter tilt;
        public final CompoundParameter spinPosition;
        public final CompoundParameter spin;
        public final CompoundParameter planeA;
        public final CompoundParameter planeB;
        public final CompoundParameter planeC;
        public final CompoundParameter planeD;
        private final PlaneConstants args;

        protected Plane(LX lx, int index) {
            super(lx);
            this.active = new BooleanParameter("Active", false);
            this.axis = new EnumParameter<Axis>("Axis", Axis.X);
            this.level = new CompoundParameter("Level", 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Brightness of this plane");
            this.position = new CompoundParameter("Position", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Position of the plane");
            this.positionMin = new BoundedParameter("Min Position", 0.0).setDescription("Minimum position of the plane");
            this.positionMax = new BoundedParameter("Max Position", 1.0).setDescription("Maximum position of the plane");
            this.width = new CompoundParameter("Width", 0.1).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Width of the plane");
            this.widthMin = new BoundedParameter("Min Width", 0.0).setDescription("Minimum width of the plane");
            this.widthMax = new BoundedParameter("Max Width", 1.0).setDescription("Maximum width of the plane");
            this.contrast = new CompoundParameter("Contrast", 0.75).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setDescription("Contrast on the plane edge");
            this.tiltPosition = new CompoundParameter("Tilt Pos", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Tilt position");
            this.tilt = new CompoundParameter("Tilt", 0.0, -180.0, 180.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Tilt of the plane");
            this.spinPosition = new CompoundParameter("Spin Pos", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Spin position");
            this.spin = new CompoundParameter("Spin", 0.0, -180.0, 180.0).setWrappable(true).setUnits(LXParameter.Units.DEGREES).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Roll of the plane");
            this.planeA = new CompoundParameter("Ax", 1.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Plane constant A");
            this.planeB = new CompoundParameter("By", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Plane constant B");
            this.planeC = new CompoundParameter("Cz", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Plane constant C");
            this.planeD = new CompoundParameter("D", 0.0, -1.0, 1.0).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Plane constant D");
            this.args = new PlaneConstants();
            this.index = index;
            this.addParameter("level", this.level);
            this.addParameter("position", this.position);
            this.addParameter("width", this.width);
            this.addParameter("contrast", this.contrast);
            this.addParameter("axis", this.axis);
            this.addParameter("tilt", this.tilt);
            this.addParameter("spin", this.spin);
            this.addParameter("tiltPosition", this.tiltPosition);
            this.addParameter("spinPosition", this.spinPosition);
            this.addParameter("active", this.active);
            this.addParameter("positionMin", this.positionMin);
            this.addParameter("positionMax", this.positionMax);
            this.addParameter("widthMin", this.widthMin);
            this.addParameter("widthMax", this.widthMax);
            this.addParameter("planeA", this.planeA);
            this.addParameter("planeB", this.planeB);
            this.addParameter("planeC", this.planeC);
            this.addParameter("planeD", this.planeD);
            this.active.setValue(index == 0);
        }

        @Override
        public String getLabel() {
            return "P" + (this.index + 1);
        }

        @Override
        public void run(double deltaMs) {
            if (!this.active.isOn()) {
                return;
            }
            Axis axis = this.axis.getEnum();
            AxisFunction function = axis.function;
            float position = LXUtils.lerpf(this.positionMin.getValuef(), this.positionMax.getValuef(), 0.5f * (1.0f + this.position.getValuef()));
            float width = 0.5f * LXUtils.lerpf(this.widthMin.getValuef(), this.widthMax.getValuef(), this.width.getValuef());
            float fade = 1.0f / width / (1.0f - this.contrast.getValuef());
            double tilt = -Math.toRadians(this.tilt.getValue());
            double spin = Math.toRadians(this.spin.getValue());
            double cosTilt = Math.cos(tilt);
            double sinTilt = Math.sin(tilt);
            double cosSpin = Math.cos(spin);
            double sinSpin = Math.sin(spin);
            switch (axis) {
                case X: 
                case Y: 
                case Z: {
                    this.args.ap = position;
                    this.args.bp = 0.5f * (1.0f + this.tiltPosition.getValuef());
                    this.args.cp = 0.5f * (1.0f + this.spinPosition.getValuef());
                    this.args.a = (float)(cosTilt * cosSpin);
                    this.args.b = (float)(sinTilt * cosSpin);
                    this.args.c = (float)(sinSpin * cosTilt);
                    this.args.invSqrt = (float)(1.0 / Math.sqrt(this.args.a * this.args.a + this.args.b * this.args.b + this.args.c * this.args.c));
                    break;
                }
                case RC: 
                case RO: {
                    this.args.d = position;
                    break;
                }
                default: {
                    this.args.a = this.planeA.getValuef();
                    this.args.b = this.planeB.getValuef();
                    this.args.c = this.planeC.getValuef();
                    this.args.d = -position - this.planeD.getValuef();
                }
            }
            float level = this.level.getValuef();
            LXPoint[] lXPointArray = this.model.points;
            int n = this.model.points.length;
            int n2 = 0;
            while (n2 < n) {
                LXPoint p = lXPointArray[n2];
                PlanesPattern.this.point.set(p);
                PlanesPattern.this.point.xn = PlanesPattern.this.transform.xn(p);
                PlanesPattern.this.point.yn = PlanesPattern.this.transform.yn(p);
                PlanesPattern.this.point.zn = PlanesPattern.this.transform.zn(p);
                float d = Math.abs(function.getDistance(PlanesPattern.this.point, this.args));
                float bn = LXUtils.minf(1.0f, 1.0f - (d - width) * fade);
                if (bn > 0.0f) {
                    this.addColor(p.index, LXColor.grayn(level * bn));
                }
                ++n2;
            }
        }
    }

    private class PlaneConstants {
        public float a;
        public float b;
        public float c;
        public float d;
        public float ap;
        public float bp;
        public float cp;
        public float invSqrt;

        private PlaneConstants() {
        }
    }
}

