/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.test;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulator.Click;
import heronarts.lx.parameter.BooleanParameter;
import heronarts.lx.parameter.BoundedParameter;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.DiscreteParameter;
import heronarts.lx.parameter.EnumParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.StringParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Test")
@LXComponent.Description(value="Utility to address and locate pixels")
public class TestPattern
extends LXPattern {
    public final EnumParameter<Mode> mode = new EnumParameter<Mode>("Mode", Mode.ITERATE).setDescription("Which mode of test operation to use");
    public final CompoundParameter rate = new CompoundParameter("Rate", 50.0, 10.0, 10000.0).setExponent(2.0).setUnits(LXParameter.Units.MILLISECONDS).setDescription("Iteration speed through points in the model");
    public final DiscreteParameter fixedIndex;
    public final StringParameter tag;
    public final BooleanParameter tagAll;
    public final DiscreteParameter tagIndex;
    public final BoundedParameter cpuTest;
    private final Click increment;
    private int active;

    public TestPattern(LX lx) {
        super(lx);
        this.fixedIndex = new DiscreteParameter("Fixed", 0, LXUtils.max(1, this.model.size)).setDescription("Fixed LED point to turn on");
        this.tag = new StringParameter("Tag", "strip").setDescription("Sets the fixture tag to query for");
        this.tagAll = new BooleanParameter("All", true).setDescription("Light up all points in the tag");
        this.tagIndex = new DiscreteParameter("Fixed", 0, LXUtils.max(1, this.model.size)).setDescription("Fixed LED point to turn on");
        this.cpuTest = new BoundedParameter("CPU Test", 0.0, 1000.0).setDescription("How many thousands of extra multiplications to perform per frame");
        this.increment = new Click(this.rate);
        this.addParameter("mode", this.mode);
        this.addParameter("rate", this.rate);
        this.addParameter("fixedIndex", this.fixedIndex);
        this.addParameter("tag", this.tag);
        this.addParameter("tagAll", this.tagAll);
        this.addParameter("tagIndex", this.tagIndex);
        this.addParameter("cpuTest", this.cpuTest);
        this.startModulator(this.increment);
        this.setAutoCycleEligible(false);
    }

    @Override
    public void onParameterChanged(LXParameter p) {
        super.onParameterChanged(p);
        if (p == this.tag) {
            this.updateTagIndex();
        }
    }

    @Override
    protected void onModelChanged(LXModel model) {
        this.fixedIndex.setRange(0, LXUtils.max(1, model.size));
        this.updateTagIndex();
    }

    private void updateTagIndex() {
        int count = 0;
        for (LXModel sub : this.model.sub(this.tag.getString())) {
            count += sub.points.length;
        }
        this.tagIndex.setRange(0, LXUtils.max(1, count));
    }

    @Override
    public void run(double deltaMs) {
        int cpuTest = 1000 * (int)this.cpuTest.getValue();
        int i = 0;
        while (i < cpuTest) {
            double d1 = Math.random();
            double d2 = Math.random();
            double d3 = Math.random();
            LXUtils.lerp(d1, d2, d3);
            ++i;
        }
        if (this.model.size == 0) {
            return;
        }
        this.setColors(-16777216);
        switch (this.mode.getEnum()) {
            case ITERATE: {
                if (this.increment.click()) {
                    ++this.active;
                }
                this.active %= this.model.points.length;
                this.colors[this.model.points[this.active].index] = -1;
                break;
            }
            case FIXED: {
                this.colors[this.model.points[this.fixedIndex.getValuei()].index] = -1;
                break;
            }
            case TAG: {
                boolean tagAll = this.tagAll.isOn();
                int tagIndex = this.tagIndex.getValuei();
                int i2 = 0;
                for (LXModel sub : this.model.sub(this.tag.getString())) {
                    if (tagAll) {
                        this.setColor(sub, -1);
                        continue;
                    }
                    LXPoint[] lXPointArray = sub.points;
                    int n = sub.points.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LXPoint p = lXPointArray[n2];
                        if (i2++ == tagIndex) {
                            this.colors[p.index] = -1;
                            return;
                        }
                        ++n2;
                    }
                }
                break;
            }
        }
    }

    public static enum Mode {
        ITERATE("Iterate Points"),
        FIXED("Fixed Index"),
        TAG("Tag");

        private final String string;

        private Mode(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

