/*
 * Decompiled with CFR 0.152.
 */
package heronarts.lx.pattern.texture;

import heronarts.lx.LX;
import heronarts.lx.LXCategory;
import heronarts.lx.LXComponent;
import heronarts.lx.color.LXColor;
import heronarts.lx.model.LXModel;
import heronarts.lx.model.LXPoint;
import heronarts.lx.modulator.LXWaveshape;
import heronarts.lx.parameter.CompoundParameter;
import heronarts.lx.parameter.LXParameter;
import heronarts.lx.parameter.ObjectParameter;
import heronarts.lx.pattern.LXPattern;
import heronarts.lx.utils.LXUtils;

@LXCategory(value="Texture")
@LXComponent.Description(value="Pixel-based sparkling with range and speed controls")
public class SparklePattern
extends LXPattern {
    public final Engine engine;
    public final CompoundParameter baseLevel;

    public SparklePattern(LX lx) {
        super(lx);
        this.engine = new Engine(this.model);
        this.baseLevel = new CompoundParameter("Base", 0.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Base Level");
        this.addParameters(this.engine.parameters);
        this.addParameter("baseLevel", this.baseLevel);
    }

    @Override
    protected void onModelChanged(LXModel model) {
        this.engine.setModel(model);
    }

    @Override
    public void run(double deltaMs) {
        this.engine.run(deltaMs, this.model, this.baseLevel.getValue(), true);
        int i = 0;
        LXPoint[] lXPointArray = this.model.points;
        int n = this.model.points.length;
        int n2 = 0;
        while (n2 < n) {
            LXPoint p = lXPointArray[n2];
            this.colors[p.index] = LXColor.gray(LXUtils.clamp(this.engine.outputLevels[i++], 0.0, 100.0));
            ++n2;
        }
    }

    public static class Engine {
        private static final int MAX_SPARKLES = 1024;
        private static final double MAX_DENSITY = 4.0;
        public final ObjectParameter<LXWaveshape> waveshape = new ObjectParameter<LXWaveshape>("Wave", new LXWaveshape[]{LXWaveshape.TRI, LXWaveshape.SIN, LXWaveshape.UP, LXWaveshape.DOWN, LXWaveshape.SQUARE});
        private final Sparkle[] sparkles = new Sparkle[1024];
        public double[] outputLevels;
        private int numSparkles;
        private int maxPixelsPerSparkle;
        public final LXParameter.Collection parameters = new LXParameter.Collection();
        public final CompoundParameter minInterval = new CompoundParameter("Fast", 1.0, 0.1, 60.0).setExponent(2.0).setUnits(LXParameter.Units.SECONDS).setDescription("Minimum interval between sparkles");
        public final CompoundParameter maxInterval = new CompoundParameter("Slow", 1.0, 0.1, 60.0).setExponent(2.0).setUnits(LXParameter.Units.SECONDS).setDescription("Maximum interval between sparkles");
        public final CompoundParameter speed = new CompoundParameter("Speed", 0.5).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Speed of the sparkle effect");
        public final CompoundParameter variation = new CompoundParameter("Variation", 25.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Variation of sparkle interval");
        public final CompoundParameter duration = new CompoundParameter("Duration", 100.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Duration of a sparkle as percentage of interval");
        public final CompoundParameter density = new CompoundParameter("Density", 50.0, 0.0, 400.0).setExponent(2.0).setUnits(LXParameter.Units.PERCENT).setDescription("Density of sparkles");
        public final CompoundParameter sharp = new CompoundParameter("Sharp", 0.0, -1.0, 1.0).setUnits(LXParameter.Units.PERCENT_NORMALIZED).setPolarity(LXParameter.Polarity.BIPOLAR).setDescription("Sharpness of sparkle curve");
        public final CompoundParameter minLevel = new CompoundParameter("Min", 75.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Minimum brightness level, as a percentage of the maximum");
        public final CompoundParameter maxLevel = new CompoundParameter("Max", 100.0, 0.0, 100.0).setUnits(LXParameter.Units.PERCENT).setDescription("Peak sparkle brightness level");
        private int currentSize = -1;

        public Engine(LXModel model) {
            this.setModel(model);
            this.parameters.add("density", this.density);
            this.parameters.add("speed", this.speed);
            this.parameters.add("variation", this.variation);
            this.parameters.add("duration", this.duration);
            this.parameters.add("sharp", this.sharp);
            this.parameters.add("waveshape", this.waveshape);
            this.parameters.add("minInterval", this.minInterval);
            this.parameters.add("maxInterval", this.maxInterval);
            this.parameters.add("minLevel", this.minLevel);
            this.parameters.add("maxLevel", this.maxLevel);
        }

        public void setModel(LXModel model) {
            if (model.size == this.currentSize) {
                return;
            }
            this.currentSize = model.size;
            this.outputLevels = new double[model.size];
            this.numSparkles = LXUtils.min(model.size, 1024);
            this.maxPixelsPerSparkle = (int)Math.ceil(4.0 * (double)model.size / (double)this.numSparkles);
            int i = 0;
            while (i < this.numSparkles) {
                this.sparkles[i] = new Sparkle(model);
                ++i;
            }
        }

        public void run(double deltaMs, LXModel model, double baseLevel, boolean render) {
            double minIntervalMs = 1000.0 * this.minInterval.getValue();
            double maxIntervalMs = 1000.0 * this.maxInterval.getValue();
            double speed = this.speed.getValue();
            double variation = 0.01 * this.variation.getValue();
            double durationInv = 100.0 / this.duration.getValue();
            double density = 0.01 * this.density.getValue();
            LXWaveshape waveshape = this.waveshape.getObject();
            double maxLevel = this.maxLevel.getValue();
            double minLevel = maxLevel * 0.01 * this.minLevel.getValue();
            double maxDelta = maxLevel - baseLevel;
            double minDelta = minLevel - baseLevel;
            double shape = this.sharp.getValue();
            shape = shape >= 0.0 ? LXUtils.lerp(1.0, 3.0, shape) : 1.0 / LXUtils.lerp(1.0, 3.0, -shape);
            int i = 0;
            while (i < this.outputLevels.length) {
                this.outputLevels[i] = baseLevel;
                ++i;
            }
            i = 0;
            while (i < this.numSparkles) {
                double sBasis;
                Sparkle sparkle = this.sparkles[i];
                double sparkleInterval = LXUtils.lerp(maxIntervalMs, minIntervalMs, LXUtils.constrain(speed + variation * (sparkle.randomVar - 0.5), 0.0, 1.0));
                sparkle.basis += deltaMs / sparkleInterval;
                if (sparkle.basis > 1.0) {
                    sparkle.basis %= 1.0;
                    int desiredPixels = (int)((double)model.size * density);
                    float desiredPixelsPerSparkle = (float)desiredPixels / (float)this.numSparkles;
                    if (desiredPixels < this.numSparkles) {
                        sparkle.activePixels = 1;
                        sparkle.isOn = Math.random() < (double)desiredPixelsPerSparkle;
                    } else {
                        sparkle.isOn = true;
                        sparkle.activePixels = Math.round(desiredPixelsPerSparkle);
                    }
                    if (sparkle.isOn) {
                        sparkle.randomVar = Math.random();
                        sparkle.randomLevel = Math.random();
                        sparkle.reindex(model);
                    }
                }
                if (sparkle.isOn && render && (sBasis = sparkle.basis * durationInv) < 1.0) {
                    double g = waveshape.compute(sBasis);
                    if (shape != 1.0) {
                        g = Math.pow(g, shape);
                    }
                    double maxSparkleDelta = LXUtils.lerp(minDelta, maxDelta, sparkle.randomLevel);
                    double sparkleAdd = maxSparkleDelta * g;
                    int c = 0;
                    while (c < sparkle.activePixels) {
                        int n = sparkle.indexBuffer[c];
                        this.outputLevels[n] = this.outputLevels[n] + sparkleAdd;
                        ++c;
                    }
                }
                ++i;
            }
        }

        private class Sparkle {
            private boolean isOn = false;
            private double basis = Math.random();
            private double randomVar = Math.random();
            private double randomLevel = Math.random();
            private int activePixels;
            private final int[] indexBuffer;

            private Sparkle(LXModel model) {
                this.indexBuffer = new int[Engine.this.maxPixelsPerSparkle];
                this.reindex(model);
            }

            private void reindex(LXModel model) {
                int i = 0;
                while (i < this.indexBuffer.length) {
                    this.indexBuffer[i] = LXUtils.randomi(model.size - 1);
                    ++i;
                }
            }
        }
    }
}

